package LDMS::Date;

# Date.pm
#
# tags the date text associated with the -CITE- catchline
#
# $Header: /home/LDMS/cvsroot/LDMS/LDMS/Date.pm,v 1.3 2000/11/30 16:19:27 jcl53 Exp $
#

use strict;
use warnings;
require 5.005;
use lib '..';  # Make sure all modules are included AFTER this.
use LDMS::XMLOut;

BEGIN {
    use Exporter ();
    our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);

    # Set our version (for module version checking).
    $VERSION = do {my @r = (q$Revision: 1.3 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r};

    @ISA = qw(Exporter);

    # Exported functions.
    @EXPORT = qw(&tagDate);
    %EXPORT_TAGS = ( );

    # Exported global variables and optional exported functions.
    @EXPORT_OK = qw();

}
our @EXPORT_OK;

# Non-exported global variables.


# Initialize exported global variables.


# Initialize non-exported global variables.


# Create private global variables.
my($month)=""; # month associated with the date
my($day)="";  #day associated with the date
my($year)="";  #year assoicated with the date
my($date)=""; #the ISO format for the date YYYY/MM/DD      
# Prototype functions.
sub tagDate;

# Module destructor.
END { }

#############################################################################
#sub tagDate
# Marks up the date in the -CITE- catchline in the format YYYY/MM/DD
# The mark up is: <DATE ACTUAL=YYYY/MM/DD></DATE>
#the array of the -CITE-text is passed in as the input argument at function call
##############################################################################
sub tagDate{
   foreach(@_){
#      chomp($_);
      if($_=~/(\d\d)\/(\d\d)\/(\d\d)/){
          $month = $1;
          $day = $2;
          $year = $3;
          if($year == 00){ $year = '20'.$year }
          else {$year = '19'.$year}
          $date="$year"."-"."$month"."-"."$day";
          &BeginTag("DATE");
          &AddAttribute("ACTUAL",$date);
	  &WriteString("$1/$2/$3");
          &EndTag("DATE");
       }
    }
}

############################## END sub tagDate{} ############################

1;
__END__;

=pod 
$Log: Date.pm,v $
Revision 1.3  2000/11/30 16:19:27  jcl53
Upped the minimum Perl interpreter version from 5.002 to 5.005, just in case someone out there does something like trying to run this script on a non-Unix system...

Revision 1.2  2000/11/28 16:00:28  jcl53
Fixed the module package name (LDMS::Date instead of LDMS::dateModule).
Removed the chomp()ing, 'cause we can safely assume the newlines have been stripped.  (And even if they aren't, the chomp() is on a read-only value, namely $_!)

Revision 1.1  2000/11/28 14:43:59  jcl53
Renamed dateModule.pm to Date.pm.

Revision 1.4  2000/11/21 21:08:54  nl42
added &'s before XMLOut functions

Revision 1.3  2000/11/21 21:02:37  nl42
preModule marks up graceful failures within the <PRE></PRE>tags

Revision 1.2  2000/11/21 21:01:15  jcl53
Added the following line to all modules to make including modules less painful:

	use lib '..';

If you're using other modules, include them AFTER this line.  Thanks.

Revision 1.1  2000/11/21 20:20:34  nl42
dateModule marks up the date in the -CITE- catchline in the format YYYY-MM-DD


