package LDMS::Table;
# Table.pm
#
# Handles tables.
#
# $Header: /home/LDMS/cvsroot/LDMS/LDMS/Table.pm,v 1.2 2000/11/28 16:20:20 jcl53 Exp $
#

use strict;
use warnings;
require 5.002;
use lib '..';
use LDMS::Error;  # LDMS error module.
use LDMS::XMLOut;
use LDMS::DataText;

BEGIN {
    use Exporter ();
    our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);

    # Set our version (for module version checking).

    @ISA = qw(Exporter);

    # Exported functions.
    @EXPORT = qw(&markUpTable &getFieldHeaders &markUpFieldData);
    %EXPORT_TAGS = ( );

    # Exported global variables and optional exported functions.
    @EXPORT_OK = qw();

}
our @EXPORT_OK;

# Non-exported global variables.


# Initialize exported global variables.


# Initialize non-exported global variables.


# Create private global variables.
my @tableBlock= @_;  #input 
my $i; #index for the current line within @tableBlock.
my @tableLineState;  #Integer to keep track of various states within the
                          #  input text.
                          #  0  Table has not started, or finished.
                          #  1  Table has started and is in headers.
                          #  2  Table has started and is in the actual data. 
                          #  10 The line is a name of the next table.
my @tableFields =();  #Array of strings to keep track of the field headers.



# Prototype functions.
sub markUpTable(@);
sub getFieldHeaders();
sub markUpFieldData();


# Module destructor.
END { }

#markUpTable(@)
#Properly tag, and use XMLOut to output the tables. 
#Pre: The input is an array of text lines. 
#     It must contain the name of the table, if there is one. 
#Post: The text will have been outputed with tables, if any, included.
sub markUpTable(@)
{
    
   @tableBlock = @_;  #input 
   my $j; #loop index

   #Go through the input data and mark each line's state. 
   for ($i=0; $i < scalar(@tableBlock); $i++)
   { 

      #Tables start with a line of multiple dashes
      if (!($tableBlock[$i] =~ /^\s*(--|---)+\s*$/x)) 
      {
         if ($i > 0)
         {
            #Generally $LineState does not change from line to line.
            $tableLineState[$i] = $tableLineState[$i-1];
         }
         else
         {
            #In the very beginning set to 0.
            $tableLineState[$i] = 0; 
         }
      }
      else
      {
         if ($i > 0)
         {
            $tableLineState[$i] = $tableLineState[$i-1] + 1;
         }
         else
         {
            #In the very beginning set to 0.
            $tableLineState[$i] = 1; 
         }
         if ($tableLineState[$i] == 1)
         {
            #Then the previous lines could be a title to the table.
            #Check to see if there are previous lines.
            if ($i > 0)
            {
               $j = $i-1; 
               while ($j >= 0)
               {
                  #It is assumed that if there is more than 3 spaces to each

                  # margin and the line is currently marked as a non-table,

                  # then the line is a name to the table.
                  
                  # Assume that each line in USCode files are 73 chars long.

                  if (($tableBlock[$j] =~ /^\s{3,}.*$/x)
                     && ($tableLineState[$j] == 0)
                     && (length($tableBlock[$j]) < 70))
                  {
                     $tableLineState[$j] = 10;
                  }
                  else
                  {
                    #No reason to check anymore, since a name 
                    # to the table has to be contigous
                    $j = -1;
                  }
                  $j--;
               }#while ($j >= 0)
            } 
         }
         if ($tableLineState[$i] == 3)
         {
            #Then the table has ended, so reset the tableLineState
            $tableLineState[$i] = 0;
         }
      }#($tableBlock[$i] =~ /^\s*\(--|---)+\s*$/x) 
   }#($i=0; $i < scalar(@tableBlock); $i++)

###########
# GetTableName
# Each line now has a state value assigned to it.
   #Check to make sure that the  
   #Start to print the Tags, use DATATEXT module to output the Divfield values.

   $i = 0;
   while ($i < scalar(@tableBlock))
   {
      my $startNonTable = $i;
      while ((($i < scalar(@tableBlock)) && $tableLineState[$i] == 0))
      {
         $i++;
      } 
      &processDataText(@tableBlock[$startNonTable..($i-1)]);
      if ($i == scalar(@tableBlock))
      { last; }
      &BeginTag("TABLE");
      my $startTableNameInd = $i;
      while ($tableLineState[$i] == 10)
      { $i++; }  
      if ($i > $startTableNameInd)
      {
         &BeginTag("TABLENAME");
         &processDataText(@tableBlock[$startTableNameInd..($i-1)]); 
         &EndTag();
      }
      if ($i == scalar(@tableBlock))
      { last; }
      $i++; #Skip the line of dashes.
      &getFieldHeaders();
      &markUpFieldData();
      #while ($i < scalar(@tableBlock))
      #{
      #  $i++; 
      #}
      &EndTag();
   }#($i < scalar(@tableBlock))

}

##########
# getFieldHeaders
#Split the field headers by 3 spaces and then put them into an array, and then pass
#the array as in input and tag using processDataText
#Pre: Table Name has already been parsed and marked up.
#     There are no EOLN chars in input.
#Post: Field headers will have been stored to $tableFields.
sub getFieldHeaders()
{
   my @tempFields; ##Store the title to each field.
   my $tableFieldInd = 0;  
   if ((($i < scalar(@tableBlock)) && $tableLineState[$i] == 1))
   {
      my $guideField = $tableBlock[$i];  #This line will be used as the guide
                                         # to determine spacing.
      my $firstFieldLine = $i; #This is the array index number where the
                               # field data starts.
      my $startOfMatch = 0; #Start of match, i.e. the beginning of the field.
                            # starts on 0.
      my $endOfMatch = 0;  #End of match, i.e. the end of the field.

      #Since $endOfMatch may change depending on the line,
      #  we want a constant of sort to be the default guide line.
      my $endGuide = 0;
      $guideField = $tableBlock[$i];  #This line will be used as the guide
                                      # to determine spacing.
      my $tableFieldInd = 0;
      #$guideField=~m/(^\s*|(\S\s{3,})|$)/xg;

      while ($guideField=~m/((\S\s{3,})|$)/xg)
      {
         $i = $firstFieldLine;
 
         $startOfMatch = $endGuide;
         
         if (pos($guideField) - 1 > length($tableBlock[$i])-1)
         {   $endOfMatch = length($tableBlock[$i])-1;   }
         else {  $endOfMatch = pos($guideField)- 1;   } 
         
         $endGuide = $endOfMatch + 1;
         

         #The first line is the start of the field name.     
         $tableFields[$tableFieldInd] = substr($tableBlock[$i], $startOfMatch,
                           $endOfMatch-$startOfMatch+1);
         $i++;
         while ((($i < scalar(@tableBlock)) && $tableLineState[$i] == 1) &&
                $startOfMatch <= length($tableBlock[$i])-1)
         {
            pos($tableBlock[$i]) = $startOfMatch;
            $tableBlock[$i] =~m/((\s{3,})|$)/xg;
            if (pos($tableBlock[$i]) -1 > $endOfMatch)
            {
               $endOfMatch = pos($tableBlock[$i])- 1;
            }
            if (pos($guideField) - 1 > length($tableBlock[$i])-1)
            {   $endOfMatch = length($tableBlock[$i])-1;   }
            else {  $endOfMatch = pos($guideField) - 1;   } 

            #Any additional lines should be simply attched to it.
            #We will use \n as the delimiter, and split it to \n before 
            #   we send the lines to processDataText() 
            $tableFields[$tableFieldInd] =$tableFields[$tableFieldInd]."\n".
               substr($tableBlock[$i], $startOfMatch,
                      $endOfMatch-$startOfMatch+1);

            $i++;
         }
         $tableFieldInd++;   
      }
   }
   else
   {
      &printErrMsg("Table does not contain any fields data.");
   }
   if ($i == scalar(@tableBlock))
   { 
      last;
      &printErrMsg("Table does not contain any fields data.");
   }
   while ($tableLineState[$i]==1)
   {
      #Skip lines.
      $i++;
   }
   $i++; #Skip the line of dashes.
}

#######
# markUpFieldData
# marks up the DivField's
# Pre: getFieldHeaders have been run.
# Post: DivField data has been marked up.

sub markUpFieldData()
{
   if (($i < scalar(@tableBlock)) && $tableLineState[$i] == 2)
   {
      my $firstFieldLine = $i; #This is the array index number where the 
                               # field data starts.
      my $startOfMatch = 0; #Start of match, i.e. the beginning of the field.
                            # starts on 0.
      my $endOfMatch = 0;  #End of match, i.e. the end of the field.

      #Since $endOfMatch may change depending on the line,
      #  we want a constant of sort to be the default guide line.
      my $endGuide;

      my $guideField = $tableBlock[$i];  #This line will be used as the guide
                                         # to determine spacing.
      my @divFieldData;  #The temporary array to store one divFieldData's worth
                         # of lines.
      my $startDivField; #The variable that stores the starting line number
                         # within a DivField scope.
      my $k = 0;
      $guideField=~m/(^\s*)/xg;
      $endGuide = pos($guideField);
      while ($guideField=~m/((\S\s{3,})|$)/xg)
      {
         $i = $firstFieldLine;
         $startOfMatch = $endGuide;

         if (pos($guideField) - 1 > length($tableBlock[$i]))
         {   $endOfMatch = length($tableBlock[$i])-1;   }
         else {  $endOfMatch = pos($guideField) - 1;   } 

         $endGuide = $endOfMatch + 1;

         &BeginTag("FIELD");
         if (scalar(@tableFields) > $k)
         {
            &BeginTag("FIELDNAME");
            &processDataText(split("\n",$tableFields[$k++]));
            &EndTag();
         }
         #print $startOfMatch."\n".$endOfMatch."\n";
         while ((($i < scalar(@tableBlock)) && $tableLineState[$i] == 2) &&
                $startOfMatch <= length($tableBlock[$i])-1)
         {
            &BeginTag("DIVFIELD");
            $startDivField = $i;

            if (pos($guideField) - 1 > length($tableBlock[$i]))
            {   $endOfMatch = length($tableBlock[$i])-1;   }
            else {  $endOfMatch = pos($guideField)- 1;   } 
            do
            {
               pos($tableBlock[$i]) = $startOfMatch;
               $tableBlock[$i] =~m/((\s{3,})|$)/xg;
               if (pos($tableBlock[$i]) -1 > $endOfMatch)
               {
                  $endOfMatch = pos($tableBlock[$i])- 1;
               }

               #If it is indented to the right, then 
               # it is a part of the previous line.
               $divFieldData[$i-$startDivField]
                  = substr($tableBlock[$i], $startOfMatch, 
                           $endOfMatch-$startOfMatch+1);
               $i++;
               while ($i < scalar(@tableBlock) 
                      &&($startOfMatch > length($tableBlock[$i])-1))
               {
                  $i++;
               } 
               if (pos($guideField) - 1 > length($tableBlock[$i]))
               {   $endOfMatch = length($tableBlock[$i])-1;   }
               else {  $endOfMatch = pos($guideField)- 1;   } 
#         print "Hello".$startOfMatch."\n".$endOfMatch."\n";
#         print pos($tableBlock[$i]);
#         print "Hello".$startOfMatch."\n".$endOfMatch."\n";
            } 
            while ((($i < scalar(@tableBlock)) && $tableLineState[$i] == 2 
                   &&($startOfMatch <= length($tableBlock[$i])-1)
                   
                   && substr($tableBlock[$i], $startOfMatch, 1) eq " ")); 
            &processDataText(@divFieldData);
            &EndTag();
            @divFieldData = ();
         }
         &EndTag(); 
      }
   }#((($i < scalar(@tableBlock)) && $tableLineState[$i] == 2)) 
   else
   {
      &printErrMsg("Table does not contain any fields data.");
   }
   while ($tableLineState[$i]==2)
   {
      #Skip lines.
      $i++;
   }
   $i++; #Skip the line of dashes.
}
1;
__END__;

=pod
