package LDMS::State;

# State.pm
#
# The state machine for the LDMS project.
#
# $Header: /home/LDMS/cvsroot/LDMS/LDMS/State.pm,v 1.6 2000/11/28 18:28:30 jcl53 Exp $
#

use strict;
use warnings;
require 5.002;
use lib '..';  # Make sure all modules are included AFTER this.


BEGIN {
    use Exporter ();
    our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);

    # Set our version (for module version checking).
    $VERSION = do {my @r = (q$Revision: 1.6 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r};

    @ISA = qw(Exporter);

    # Exported functions.
    @EXPORT = qw(&initState &ascendLevel &descendLevel &getHLevel &getVLevel &getLevelLabel &getSequence &advanceLevel &labelInPath &initFootnoteNumbers &incrFootnoteNumber &getFootnoteNumber);
    %EXPORT_TAGS = ( );

    # Exported global variables and optional exported functions.
    @EXPORT_OK = qw();

}
our @EXPORT_OK;

# Non-exported global variables.


# Initialize exported global variables.


# Initialize non-exported global variables.


# Create private global variables.
my @path = ();
my @sequence = ();
my @footnoteNumbers = ();


# Prototype functions.
sub initState();
sub ascendLevel();
sub descendLevel($);
sub getHLevel();
sub getVLevel();
sub getLevelLabel();
sub getSequence();
sub advanceLevel();
sub labelInPath($);
sub initFootnoteNumbers();
sub incrFootnoteNumber($);
sub getFootnoteNumber($);


# Module destructor.
END { }


# Insert functions, code, &c., here.


#==============================================================================
# INITIALIZE STATE MACHINE
sub initState() {

    @path = ();
    @sequence = ();

}


#==============================================================================
# DESCEND ONE LEVEL
sub descendLevel($) {

    my $levelName = shift;

    unshift(@path, $levelName);
    unshift(@sequence, 0);

}


#==============================================================================
# ASCEND ONE LEVEL
sub ascendLevel() {

    shift(@path);
    shift(@sequence);

}


#==============================================================================
# GET HORIZONTAL LEVEL
sub getHLevel() {

    if (scalar(@sequence) > 0) {
	return $sequence[0];
    }
    else {
	return 0;
    }

}


#==============================================================================
# GET VERTICAL LEVEL
sub getVLevel() {

    if (scalar(@path) > 0) {
	return (scalar(@path) - 1);
    }
    else {  # There's nothing in the path, doofus!
	return -1;
    }

}


#==============================================================================
# GET SEQUENCE PATH
sub getSequence() {

    return @sequence;

}


#==============================================================================
# GET LABEL OF CURRENT LEVEL
sub getLevelLabel() {

    if (scalar(@path) > 0) {
	return $path[0];
    }
    else {
	return "";
    }

}


#==============================================================================
# ADVANCE ONE HORIZONTAL LEVEL
sub advanceLevel() {

    $sequence[0]++;
    return $sequence[0];

}


#==============================================================================
# CHECK IF PATH CONTAINS LABEL
sub labelInPath($) {

    my $label = shift;

    my $flag = 0;  # Has the label been found yet?

    for (my $i = 0; $i < scalar(@path); $i++) {
	if ((scalar(@path) > 0) &&
	    ($path[$i] eq $label)) {
	    $flag = 1;
	}
    }

    return $flag;

}


#==============================================================================
# INITIALIZE FOOTNOTE NUMBERS
sub initFootnoteNumbers() {

    @footnoteNumbers = ();

}


#==============================================================================
# INCREMENT FOOTNOTE NUMBER
sub incrFootnoteNumber($) {
    my $foo = shift;

    $foo = $foo - 1;

    if ($foo >= 0) {  # Make sure we're not out-of-bounds.
	if (! defined($footnoteNumbers[$foo])) {
	    $footnoteNumbers[$foo] = 1.0;
	} else {
	    $footnoteNumbers[$foo] = $footnoteNumbers[$foo] + .1;
	}
    }

}

#==============================================================================
# GET FOOTNOTE NUMBER
sub getFootnoteNumber($) {

    my $foo = shift;

    $foo = $foo - 1;
    if (! defined($footnoteNumbers[$foo])) {
        return 1.0;
    } else {
        return $footnoteNumbers[$foo];
    }

}



1;
__END__;

=pod 
$Log: State.pm,v $
Revision 1.6  2000/11/28 18:28:30  jcl53
Added code to use footnote module in LDMS::DataText.
Fixed a few syntax problems introduced into the state machine.

Revision 1.5  2000/11/28 16:27:35  jcl53
Added a little comment to the 'use lib' lines.  Modules (especially LDMS ones) should be included after them so that testing compilation with 'perl -c' works.

Revision 1.4  2000/11/27 19:20:24  om14
I fixed some compilation errors in the State.pm module such as using @ vs. $ for indexing arrays, etc.

Revision 1.3  2000/11/27 16:48:22  om14
I have created the first version of the Footnote.pm module and updated the State.pm module to reflect the footnote "state machine."

Revision 1.2  2000/11/21 21:01:15  jcl53
Added the following line to all modules to make including modules less painful:

	use lib '..';

If you're using other modules, include them AFTER this line.  Thanks.

Revision 1.1  2000/11/17 20:02:44  jcl53
This module implements a state machine for the LDMS project.  Be nice to it, or it might break.

