import java.awt.*;
import java.util.*;

public class ImageManager
{
    private static Hashtable imageTable;
    public static final Toolkit tk = Toolkit.getDefaultToolkit();
    public static final String imagePath = "../gfx/";
    public static final String[] names = new String[] { 
    	"boarddark","board",
    	"squidR0"	,"squidB0"	,"whaleR0"	,"whaleB0"
    	,"squidR1"	,"squidB1"	,"whaleR1"	,"whaleB1"
    	,"squidR2"	,"squidB2"	,"whaleR2"	,"whaleB2"
    	,"squidR3"	,"squidB3"	,"whaleR3"	,"whaleB3"
    	,"squidR4"	,"squidB4"	,"whaleR4"	,"whaleB4"
    	,"squidR5"	,"squidB5"	,"whaleR5"	,"whaleB5"
    	,"squidR6"	,"squidB6"	,"whaleR6"	,"whaleB6"
    	,"squidR7"	,"squidB7"	,"whaleR7"	,"whaleB7"
    	,"empty","treasure","coral","board","ink"
    };
    
    
    public static void Init()
    {
        imageTable = new Hashtable();
        MediaTracker mediaTracker = new MediaTracker(new Panel());
		
        // Load images
        for (int i = 0; i < names.length; i++)
        {
        	Image im = tk.getImage(imagePath + names[i] + ".png");
        	imageTable.put(names[i], im);
        	mediaTracker.addImage(im, i);
        }
        
//        Image im = ((Image)imageTable.get("spawn")).getScaledInstance(10,10,Image.SCALE_SMOOTH);
//        imageTable.put("credit", im);
//        mediaTracker.addImage(im,names.length + 1);

		try
		{
		    // Synchronize image loading
			mediaTracker.waitForAll();
		}
		catch (InterruptedException ie)
		{
			System.err.println(ie);
			System.exit(1);
		}
    }
    
    public static Image GetImage(String name)
    {
        return (Image)imageTable.get(name);
    }
}
