import java.net.BindException;
import java.io.IOException;

public class Gui
{
    public static Board board;
    
    public static String Syntax()
    {
        return "Syntax: java Gui [ip-address] [port]";
    }

    public static void main(String args[])
    {
        int port = 2005;
        String host = "localhost";

        if (args.length > 2)
        {
            System.out.println(Syntax());
            return;
        }

        if (args.length > 0) 
        {
            host = args[0];
        }

        if (args.length > 1) 
        {
            try
            {
                port = Integer.parseInt(args[1]);
            }
            catch (Exception e) 
            { 
                System.out.println(Syntax());
                return;
            }
        
            if (port < 0)
            {
                System.out.println(Syntax());
                return;           
            }
        }

        ImageManager.Init();
        board = new Board();
        try {
            while (true) {
                if (!Connection.Connect(host, port))
                {
                    System.out.println("Error receiving connection from " + 
                                       host + ":" + port);

                    System.exit(1);
                }
                board.Light();        
                Connection.Loop();
            }
        } catch (BindException e) {
          e.printStackTrace();
          System.err.println("Error binding to port: " + e.getMessage());
        } catch (IOException e) {
          System.err.println("IOException: " + e.getMessage());
        }
    }
    
}
