import java.io.*;
import java.net.*;
import java.util.*;

public class Connection {
    private static ServerSocket server;
    private static Socket socket; 
    private static BufferedReader input;
    private static BufferedWriter output;
    
    public static boolean Connect(String addr, int port) throws IOException {
    	int attempts = 0;
        System.out.println("Waiting for connection from world...");
        //System.err.println("Called connect");
        server = new ServerSocket(port);
        socket = server.accept();
        //System.out.println("Connection accepted.");
        InetAddress iaddr = InetAddress.getByName(addr);

        socket.setSoTimeout(2000); //Sets socket timeout to 2 seconds

        input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        output = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));

        //System.out.println("Reading line...");
        /* first line should be [CONNECTING] */
        String message = input.readLine();
        if(message == null || (!message.equals("[CONNECTING]"))) {
            System.out.println("Unknown client! Disconnecting...");
            socket.close();
            return false;
        }
        
        //System.out.println("Line read.");
        /* respond with [CONNECTED] */
        output.write("[CONNECTED]\n", 0, 12);
        output.flush();	
        
        System.out.println("Connection established!");
        return true;
    }
    
    public static boolean IsConnected() {
    	return socket != null;
    }

    public static void cleanup() {
        try {
            if (input != null) {
                input.close();
                input = null;
            }
            if (output != null) {
                output.close();
                output = null;
            }
            if (socket != null) {
                socket.close();
                socket = null;
            }
            if (server != null) {
                server.close();
                server = null;
            }
        } catch (IOException e) {
        }
    }

    public static String ReceiveLine() throws IOException {
        return input.readLine();
    }
    
    public static void Team(boolean red, String name) {
    	Gui.board.WriteName(red, name);
    }
    /*    
    public static void Credits(int r, int b) {
    	Gui.board.WriteCredits(true, r);
    	Gui.board.WriteCredits(false, b);
    	//Gui.board.WriteText("[Credits]  Red: " + r + "    Blue: " + b);
    }
    */
    public static void Score(int r, int b) {
    	Gui.board.WriteScore(true, r);
    	Gui.board.WriteScore(false, b);
    	//Gui.board.WriteText("[Score]  Red: " + r + "    Blue: " + b);
    }
    
    public static void Timer(int steps) throws IOException {
	Gui.board.WriteTimer(steps);
    }

    public static void Set(String id, int x, int y) {
        Gui.board.SetPiece(id, x, y);
    }
    
    public static void Chat(boolean red, String text) {
    	Gui.board.WriteText((red ? "[RED]  " : "[BLUE]  ") + text);
    }
    
    public static String MergeTokens(StringTokenizer st) {
    	String result = "";
    	while(st.hasMoreTokens()) {
    		result += st.nextToken() + " ";
    	}
    	return result;
    }
    
    public static void Loop() {
        String command = "";

        while(true) {
            try {
                command = ReceiveLine();
                if (command == null) {
                    System.out.println("Connection ended with server.");
                    cleanup();
                    return;
                }
                StringTokenizer st = new StringTokenizer(command);
                String type = st.nextToken();
                
                /* Demux incoming command */
                if (type.equals("name"))
                    Team(st.nextToken().equals("red"), MergeTokens(st));

                else if (type.equals("treasures"))
                    Score(Integer.parseInt(st.nextToken()),
                            Integer.parseInt(st.nextToken()));

                else if (type.equals("score"))
                    Score(Integer.parseInt(st.nextToken()),
                          Integer.parseInt(st.nextToken()));

		else if (type.equals("time"))
                    Timer(Integer.parseInt(st.nextToken()));

                else if (type.equals("set"))
                    Set(st.nextToken(), 
                         Integer.parseInt(st.nextToken()),
                         Integer.parseInt(st.nextToken()));
                 
                else if (type.equals("chat"))
                    Chat(st.nextToken().equals("red"), MergeTokens(st));
		else
		    System.out.println("Unknown Command: "+command);
                
            } catch (IOException ioe) {
                // Connection reset
                System.out.println("Connection reset by peer: " + ioe.getMessage());
                cleanup();
                return;
            } catch (Exception e) { 
                System.out.println("Incorrect command! (ignored): " + e.getMessage());
            }
        }
    }
}
