import javax.swing.*;

import java.awt.*;
import java.awt.image.*;
import java.util.*;

public class Board extends JFrame
{
    
    public static final String gameName = "20,000 Lambdas Under the Sea";
    
    public static final int WINDOW_WIDTH = 990;
    public static final int WINDOW_HEIGHT = 725;
    public static final int BOARD_WIDTH = 985;
    public static final int BOARD_HEIGHT = 700;
    public static final Color textBgColor = new Color(94,111,99);
    
    public Graphics gScreen, gBuffer;
    public Image iBuffer;
    private Canvas canvas;
    private String redName = "", blueName = "";
    private int redLambdas = 0, blueLambdas = 0;
    private int redScore = 0, blueScore = 0;
    private int timer = 0;
    
    private class Piece
    {
        public String id;
        public Image image;
        public int x,y;
        
        public Piece(String id, Image image, int x, int y)
        {
            this.id = id;
            this.image = image;
            this.x = x;
            this.y = y;
        }
    }
    
    private class BackgroundPanel extends JPanel
    {
	public Image background;
	
	public BackgroundPanel(Image bg)
	{
	    super();
	    background = bg;
	    setOpaque(false);
	    
	}
	public void paint(Graphics g)
	{
	    g.drawImage(background, 0, 0, this);
	    super.paint(g);
	}
    }
    private Hashtable<String,Piece> pieces;
    
    /**
     * Sets a piece at position (x,y) to specified image handle (id)
     * 
     * @param id - the imageName of this piece
     * @param x - the x-coordinate of this piece
     * @param y - the y-coordinate of this piece
     * @return - returns true iff the piece was successfully set
     */
    public boolean SetPiece(String id, int x, int y)
    {
    	// check to see if it has a mapping
    	Image i = ImageManager.GetImage(id);
    	// if it doesn't
    	if (i == null) return false;
    	
    	// unique identifier for each square on the board
    	String key = x+","+y;
	
    	// check to see if the piece already exists
    	Piece p = pieces.get(key);
    	
    	// if it doesn't
        if (p == null){
	    // if it does, create a new piece
	    p = new Piece(id, i, x, y);
	    pieces.put(key, p);
        }else{
	    p.image = i;
	    p.x = x;
	    p.y = y;
        }
        DrawPiece(p);
        return true;
    }
    
    public void WriteName(boolean red, String name)
    {
    	int x = 0, y = 510;
    	if (red) {
	    x = 110;
	    redName = name;
	} else {
	    x = 635;
	    blueName = name;
    	}
    	
    	FontMetrics fm = gBuffer.getFontMetrics();
    	int height = 
            (int)Math.ceil(fm.getStringBounds(name, gBuffer).getHeight());
    	int width = 
            (int)Math.ceil(fm.getStringBounds(name, gBuffer).getWidth());
    	
    	while(width > 219) 
    	{
    	    name = name.substring(0, name.length() - 1);
    	    width = 
                (int)Math.ceil(fm.getStringBounds(name, gBuffer).getWidth());
    	}
    	
    	gBuffer.setColor(textBgColor);
    	gBuffer.fillRect(x, y, 220, 23);
    	gBuffer.setColor(Color.white);
    	gBuffer.drawString(name, x + (220 - width)/2, y + 8 + height/2);

    	gScreen.drawImage(iBuffer, 
                          x, y, x + 219, y + 22, 
                          x, y, x + 219, y + 22, 
                          null);
    }
    /*    
    public void WriteCredits(boolean red, int value)
    {
    	if (red)
	    redLambdas = value;
    	else
	    blueLambdas = value;
    	
    	WriteStats(red);
    }
    
    public void WriteStats(boolean red)
    {
	int x = 0, y = 510;
	String lambdas;
	if (red)
	    {
		x = 60;
		lambdas = "" + redLambdas;
	    }
	else
	    {
		x = 905 - 38;
		lambdas = "" + blueLambdas;
	    }
	
	FontMetrics fm = gBuffer.getFontMetrics();
	int height = (int)Math.ceil(fm.getStringBounds(lambdas, gBuffer).getHeight());
	int width = (int)Math.ceil(fm.getStringBounds(lambdas, gBuffer).getWidth());
	
	gBuffer.setColor(textBgColor);
	gBuffer.fillRect(x, y, 38, 23);
	gBuffer.setColor(Color.white);
	gBuffer.drawString(lambdas, 
			   x + 2 + (36 - width)/2, y + 8 + height/2);		
	gScreen.drawImage(iBuffer, 
			  x, y, x + 38, y + 22, 
			  x, y, x + 38, y + 22, 
			  null);
    }
    
    */
        
    public void WriteScore(boolean red, int value)
    {
    	if (red) redScore = value;
    	else blueScore = value;
    	
    	WriteScoreStats(red);
    }


    public void WriteScoreStats(boolean red) {
	int x = 0, y = 510;
	String lambdas;
	if (red)
	    {
		x = 360;
		lambdas = "" + redScore;
	    }
	else
	    {
		x = 605 - 38;
		lambdas = "" + blueScore;
	    }
	
	FontMetrics fm = gBuffer.getFontMetrics();
	int height = (int)Math.ceil(fm.getStringBounds(lambdas, gBuffer).getHeight());
	int width = (int)Math.ceil(fm.getStringBounds(lambdas, gBuffer).getWidth());
	
	gBuffer.setColor(Color.lightGray);
	gBuffer.fillRect(x, y, 38, 23);
       	if (red) gBuffer.setColor(Color.red);
	else gBuffer.setColor(Color.blue);
	gBuffer.drawString(lambdas, 
			   x + 2 + (36 - width)/2, y + 8 + height/2);		
	gScreen.drawImage(iBuffer, 
			  x, y, x + 38, y + 22, 
			  x, y, x + 38, y + 22, 
			  null);
    }
    

    public void WriteTimer(int value)  {
	int x = 435, y = 510;
    	if (value>=0) timer=value;
	String lambdas = ""+timer;
	FontMetrics fm = gBuffer.getFontMetrics();
	int height = (int)Math.ceil(fm.getStringBounds(lambdas, gBuffer).getHeight());
	int width = (int)Math.ceil(fm.getStringBounds(lambdas, gBuffer).getWidth());
	
	gBuffer.setColor(textBgColor);
	gBuffer.fillRect(x, y, 100, 23);
       	gBuffer.setColor(Color.white);
	gBuffer.drawString(lambdas, 
			   x + (100 - width)/2, y + 8 + height/2);		
	gScreen.drawImage(iBuffer, 
			  x, y, x + 99, y + 22, 
			  x, y, x + 99, y + 22, 
			  null);
    }


    public void WriteText(String text) 
    {
    	FontMetrics fm = gBuffer.getFontMetrics();
    	int lineHeight = 
            (int) Math.ceil(fm.getStringBounds("|qX", gBuffer).getHeight());
    	
    	String str = text;
    	String leftover = "";
    	
    	// size of talking window
    	int x1 = 110; //55
    	int x2 = 855; //740
    	int y1 = 548; //535
    	int y2 = 660; //660
    	
    	while (Math.ceil(fm.getStringBounds(str, gBuffer).getWidth()) > 740) 
    	{
    		leftover = str.substring(str.length() - 1) + leftover;
    		str = str.substring(0, str.length() - 1);
    	}
    	
    	gBuffer.copyArea(x1, y1 + lineHeight, x2, 136, 0, - lineHeight);
    	
    	gBuffer.setColor(textBgColor);
    	gBuffer.fillRect(x1, y2 - lineHeight + 3, x2, lineHeight);
    	gBuffer.setColor(Color.white);
    	gBuffer.drawString(str, x1, y2-2);
    	
    	if (!leftover.equals("")) {
    		WriteText("        " + leftover);
    		return;
    	}
    	
    	gScreen.drawImage(iBuffer, x1-5, y1, x2, y2, x1-5, y1, x2, y2, null);
    }
    
    public Board()
    {
        pieces = new Hashtable();
        setTitle(gameName);
        setSize(WINDOW_WIDTH, WINDOW_HEIGHT);
        
        iBuffer = new BufferedImage(BOARD_WIDTH, BOARD_HEIGHT, BufferedImage.TYPE_INT_RGB);
        gBuffer = iBuffer.getGraphics();
        BackgroundPanel bp = new BackgroundPanel(iBuffer);
        
	gBuffer.drawImage(GetBoardImage(), 0, 0, null);
        this.getContentPane().add(bp);
        
        ShutdownAgent hooks = new ShutdownAgent();
        sun.misc.Signal.handle(new sun.misc.Signal("INT"), hooks);
    	this.addWindowListener(hooks);
        
        this.setVisible(true);
	    gScreen = bp.getGraphics();
        
        this.update(this.getGraphics());
            
    }
    
    public Image GetBoardImage()
    {
    	return (Connection.IsConnected() ? 
                ImageManager.GetImage("board") : 
                ImageManager.GetImage("boarddark"));
    }
        
    public void Light()
    {
    	 this.gBuffer.drawImage(GetBoardImage(), 0, 0, null);
	 /*    	 this.WriteStats(true);
		 this.WriteStats(false); */
	 this.WriteScoreStats(true);
    	 this.WriteScoreStats(false);
	 this.WriteTimer(-1);
    	 this.update(this.getGraphics());
    	 this.toFront();
    }
    
    public void DrawPiece(Piece p)
    {
		PutImage(p.image, p.x, p.y);	
    }
    
    public void PutImage(Image i, int x, int y)
    {
    	int s = 30, xoff = 10, yoff = 20;
	    gBuffer.drawImage(i, x*s + xoff, y*s + yoff, null);
	    gScreen.drawImage(i, x*s + xoff, y*s + yoff, s, s, null);
    }
}
