/* The following code was generated by JFlex 1.5.1 */

/*
 * This file is part of the Polyglot extensible compiler framework.
 *
 * Copyright (c) 2000-2006 Polyglot project group, Cornell University
 * 
 */

/* Java 1.4 scanner for JFlex.
 * Based on JLS, 2ed, Chapter 3.
 */

package polyglot.qq;

import polyglot.lex.Lexer;
import polyglot.lex.*;
import polyglot.ast.*;
import polyglot.util.Position;
import polyglot.util.InternalCompilerError;
import java.util.*;
import java.io.StringReader;
import java.math.BigInteger;

@SuppressWarnings({"unused", "fallthrough", "all"})

/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.5.1
 * from the specification file <tt>qq.flex</tt>
 */
public class Lexer_c implements Lexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int STRING = 2;
  public static final int CHARACTER = 4;
  public static final int TRADITIONAL_COMMENT = 6;
  public static final int END_OF_LINE_COMMENT = 8;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4, 4
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\5\1\3\1\1\1\70\1\71\1\2\16\5\4\0\1\3\1\57"+
    "\1\34\1\0\1\4\1\20\1\63\1\33\1\44\1\45\1\32\1\65"+
    "\1\53\1\15\1\13\1\31\1\6\3\17\4\12\2\7\1\62\1\52"+
    "\1\56\1\54\1\55\1\61\1\0\3\11\1\25\1\22\1\27\5\4"+
    "\1\30\1\26\5\4\1\23\1\24\3\4\1\10\2\4\1\50\1\16"+
    "\1\51\1\66\1\4\1\0\1\41\1\73\1\11\1\67\1\14\1\40"+
    "\5\4\1\42\1\4\1\43\3\4\1\36\1\21\1\35\1\37\2\4"+
    "\1\10\2\4\1\46\1\64\1\47\1\60\6\5\1\72\32\5\2\0"+
    "\4\4\4\0\1\4\2\0\1\5\7\0\1\4\4\0\1\4\5\0"+
    "\27\4\1\0\37\4\1\0\u01ca\4\4\0\14\4\16\0\5\4\7\0"+
    "\1\4\1\0\1\4\21\0\160\5\5\4\1\0\2\4\2\0\4\4"+
    "\10\0\1\4\1\0\3\4\1\0\1\4\1\0\24\4\1\0\123\4"+
    "\1\0\213\4\1\0\5\5\2\0\236\4\11\0\46\4\2\0\1\4"+
    "\7\0\47\4\7\0\1\4\1\0\55\5\1\0\1\5\1\0\2\5"+
    "\1\0\2\5\1\0\1\5\10\0\33\4\5\0\3\4\15\0\5\5"+
    "\6\0\1\4\4\0\13\5\5\0\53\4\37\5\4\0\2\4\1\5"+
    "\143\4\1\0\1\4\10\5\1\0\6\5\2\4\2\5\1\0\4\5"+
    "\2\4\12\5\3\4\2\0\1\4\17\0\1\5\1\4\1\5\36\4"+
    "\33\5\2\0\131\4\13\5\1\4\16\0\12\5\41\4\11\5\2\4"+
    "\4\0\1\4\5\0\26\4\4\5\1\4\11\5\1\4\3\5\1\4"+
    "\5\5\22\0\31\4\3\5\104\0\1\4\1\0\13\4\67\0\33\5"+
    "\1\0\4\5\66\4\3\5\1\4\22\5\1\4\7\5\12\4\2\5"+
    "\2\0\12\5\1\0\7\4\1\0\7\4\1\0\3\5\1\0\10\4"+
    "\2\0\2\4\2\0\26\4\1\0\7\4\1\0\1\4\3\0\4\4"+
    "\2\0\1\5\1\4\7\5\2\0\2\5\2\0\3\5\1\4\10\0"+
    "\1\5\4\0\2\4\1\0\3\4\2\5\2\0\12\5\4\4\7\0"+
    "\1\4\5\0\3\5\1\0\6\4\4\0\2\4\2\0\26\4\1\0"+
    "\7\4\1\0\2\4\1\0\2\4\1\0\2\4\2\0\1\5\1\0"+
    "\5\5\4\0\2\5\2\0\3\5\3\0\1\5\7\0\4\4\1\0"+
    "\1\4\7\0\14\5\3\4\1\5\13\0\3\5\1\0\11\4\1\0"+
    "\3\4\1\0\26\4\1\0\7\4\1\0\2\4\1\0\5\4\2\0"+
    "\1\5\1\4\10\5\1\0\3\5\1\0\3\5\2\0\1\4\17\0"+
    "\2\4\2\5\2\0\12\5\1\0\1\4\17\0\3\5\1\0\10\4"+
    "\2\0\2\4\2\0\26\4\1\0\7\4\1\0\2\4\1\0\5\4"+
    "\2\0\1\5\1\4\7\5\2\0\2\5\2\0\3\5\10\0\2\5"+
    "\4\0\2\4\1\0\3\4\2\5\2\0\12\5\1\0\1\4\20\0"+
    "\1\5\1\4\1\0\6\4\3\0\3\4\1\0\4\4\3\0\2\4"+
    "\1\0\1\4\1\0\2\4\3\0\2\4\3\0\3\4\3\0\14\4"+
    "\4\0\5\5\3\0\3\5\1\0\4\5\2\0\1\4\6\0\1\5"+
    "\16\0\12\5\11\0\1\4\7\0\3\5\1\0\10\4\1\0\3\4"+
    "\1\0\27\4\1\0\12\4\1\0\5\4\3\0\1\4\7\5\1\0"+
    "\3\5\1\0\4\5\7\0\2\5\1\0\2\4\6\0\2\4\2\5"+
    "\2\0\12\5\22\0\2\5\1\0\10\4\1\0\3\4\1\0\27\4"+
    "\1\0\12\4\1\0\5\4\2\0\1\5\1\4\7\5\1\0\3\5"+
    "\1\0\4\5\7\0\2\5\7\0\1\4\1\0\2\4\2\5\2\0"+
    "\12\5\1\0\2\4\17\0\2\5\1\0\10\4\1\0\3\4\1\0"+
    "\51\4\2\0\1\4\7\5\1\0\3\5\1\0\4\5\1\4\10\0"+
    "\1\5\10\0\2\4\2\5\2\0\12\5\12\0\6\4\2\0\2\5"+
    "\1\0\22\4\3\0\30\4\1\0\11\4\1\0\1\4\2\0\7\4"+
    "\3\0\1\5\4\0\6\5\1\0\1\5\1\0\10\5\22\0\2\5"+
    "\15\0\60\4\1\5\2\4\7\5\4\0\10\4\10\5\1\0\12\5"+
    "\47\0\2\4\1\0\1\4\2\0\2\4\1\0\1\4\2\0\1\4"+
    "\6\0\4\4\1\0\7\4\1\0\3\4\1\0\1\4\1\0\1\4"+
    "\2\0\2\4\1\0\4\4\1\5\2\4\6\5\1\0\2\5\1\4"+
    "\2\0\5\4\1\0\1\4\1\0\6\5\2\0\12\5\2\0\4\4"+
    "\40\0\1\4\27\0\2\5\6\0\12\5\13\0\1\5\1\0\1\5"+
    "\1\0\1\5\4\0\2\5\10\4\1\0\44\4\4\0\24\5\1\0"+
    "\2\5\5\4\13\5\1\0\44\5\11\0\1\5\71\0\53\4\24\5"+
    "\1\4\12\5\6\0\6\4\4\5\4\4\3\5\1\4\3\5\2\4"+
    "\7\5\3\4\4\5\15\4\14\5\1\4\17\5\2\0\46\4\1\0"+
    "\1\4\5\0\1\4\2\0\53\4\1\0\u014d\4\1\0\4\4\2\0"+
    "\7\4\1\0\1\4\1\0\4\4\2\0\51\4\1\0\4\4\2\0"+
    "\41\4\1\0\4\4\2\0\7\4\1\0\1\4\1\0\4\4\2\0"+
    "\17\4\1\0\71\4\1\0\4\4\2\0\103\4\2\0\3\5\40\0"+
    "\20\4\20\0\125\4\14\0\u026c\4\2\0\21\4\1\0\32\4\5\0"+
    "\113\4\3\0\3\4\17\0\15\4\1\0\4\4\3\5\13\0\22\4"+
    "\3\5\13\0\22\4\2\5\14\0\15\4\1\0\3\4\1\0\2\5"+
    "\14\0\64\4\40\5\3\0\1\4\3\0\2\4\1\5\2\0\12\5"+
    "\41\0\3\5\2\0\12\5\6\0\130\4\10\0\51\4\1\5\1\4"+
    "\5\0\106\4\12\0\35\4\3\0\14\5\4\0\14\5\12\0\12\5"+
    "\36\4\2\0\5\4\13\0\54\4\4\0\21\5\7\4\2\5\6\0"+
    "\12\5\46\0\27\4\5\5\4\0\65\4\12\5\1\0\35\5\2\0"+
    "\13\5\6\0\12\5\15\0\1\4\130\0\5\5\57\4\21\5\7\4"+
    "\4\0\12\5\21\0\11\5\14\0\3\5\36\4\15\5\2\4\12\5"+
    "\54\4\16\5\14\0\44\4\24\5\10\0\12\5\3\0\3\4\12\5"+
    "\44\4\122\0\3\5\1\0\25\5\4\4\1\5\4\4\3\5\2\4"+
    "\11\0\300\4\47\5\25\0\4\5\u0116\4\2\0\6\4\2\0\46\4"+
    "\2\0\6\4\2\0\10\4\1\0\1\4\1\0\1\4\1\0\1\4"+
    "\1\0\37\4\2\0\65\4\1\0\7\4\1\0\1\4\3\0\3\4"+
    "\1\0\7\4\3\0\4\4\2\0\6\4\4\0\15\4\5\0\3\4"+
    "\1\0\7\4\16\0\5\5\30\0\1\70\1\70\5\5\20\0\2\4"+
    "\23\0\1\4\13\0\5\5\5\0\6\5\1\0\1\4\15\0\1\4"+
    "\20\0\15\4\3\0\33\4\25\0\15\5\4\0\1\5\3\0\14\5"+
    "\21\0\1\4\4\0\1\4\2\0\12\4\1\0\1\4\3\0\5\4"+
    "\6\0\1\4\1\0\1\4\1\0\1\4\1\0\4\4\1\0\13\4"+
    "\2\0\4\4\5\0\5\4\4\0\1\4\21\0\51\4\u0a77\0\57\4"+
    "\1\0\57\4\1\0\205\4\6\0\4\4\3\5\2\4\14\0\46\4"+
    "\1\0\1\4\5\0\1\4\2\0\70\4\7\0\1\4\17\0\1\5"+
    "\27\4\11\0\7\4\1\0\7\4\1\0\7\4\1\0\7\4\1\0"+
    "\7\4\1\0\7\4\1\0\7\4\1\0\7\4\1\0\40\5\57\0"+
    "\1\4\u01d5\0\3\4\31\0\11\4\6\5\1\0\5\4\2\0\5\4"+
    "\4\0\126\4\2\0\2\5\2\0\3\4\1\0\132\4\1\0\4\4"+
    "\5\0\51\4\3\0\136\4\21\0\33\4\65\0\20\4\u0200\0\u19b6\4"+
    "\112\0\u51cd\4\63\0\u048d\4\103\0\56\4\2\0\u010d\4\3\0\20\4"+
    "\12\5\2\4\24\0\57\4\1\5\4\0\12\5\1\0\31\4\7\0"+
    "\1\5\120\4\2\5\45\0\11\4\2\0\147\4\2\0\4\4\1\0"+
    "\4\4\14\0\13\4\115\0\12\4\1\5\3\4\1\5\4\4\1\5"+
    "\27\4\5\5\20\0\1\4\7\0\64\4\14\0\2\5\62\4\21\5"+
    "\13\0\12\5\6\0\22\5\6\4\3\0\1\4\4\0\12\5\34\4"+
    "\10\5\2\0\27\4\15\5\14\0\35\4\3\0\4\5\57\4\16\5"+
    "\16\0\1\4\12\5\46\0\51\4\16\5\11\0\3\4\1\5\10\4"+
    "\2\5\2\0\12\5\6\0\27\4\3\0\1\4\1\5\4\0\60\4"+
    "\1\5\1\4\3\5\2\4\2\5\5\4\2\5\1\4\1\5\1\4"+
    "\30\0\3\4\2\0\13\4\5\5\2\0\3\4\2\5\12\0\6\4"+
    "\2\0\6\4\2\0\6\4\11\0\7\4\1\0\7\4\221\0\43\4"+
    "\10\5\1\0\2\5\2\0\12\5\6\0\u2ba4\4\14\0\27\4\4\0"+
    "\61\4\u2104\0\u016e\4\2\0\152\4\46\0\7\4\14\0\5\4\5\0"+
    "\1\4\1\5\12\4\1\0\15\4\1\0\5\4\1\0\1\4\1\0"+
    "\2\4\1\0\2\4\1\0\154\4\41\0\u016b\4\22\0\100\4\2\0"+
    "\66\4\50\0\15\4\3\0\20\5\20\0\7\5\14\0\2\4\30\0"+
    "\3\4\31\0\1\4\6\0\5\4\1\0\207\4\2\0\1\5\4\0"+
    "\1\4\13\0\12\5\7\0\32\4\4\0\1\4\1\0\32\4\13\0"+
    "\131\4\3\0\6\4\2\0\6\4\2\0\6\4\2\0\3\4\3\0"+
    "\2\4\3\0\2\4\22\0\3\5\4\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\5\0\1\1\2\2\1\3\2\4\1\5\1\6\1\7"+
    "\1\10\1\11\1\12\1\13\3\3\1\14\1\15\1\16"+
    "\1\17\1\20\1\21\1\22\1\23\1\24\1\25\1\26"+
    "\1\27\1\30\1\31\1\32\1\33\1\34\1\35\1\36"+
    "\1\37\2\40\1\1\1\41\1\37\2\42\1\1\1\43"+
    "\1\2\2\44\1\45\2\0\1\46\1\0\1\47\1\50"+
    "\1\51\1\52\1\53\1\54\1\55\1\56\1\57\1\60"+
    "\1\61\1\62\1\0\1\63\1\64\1\65\1\66\1\67"+
    "\3\3\1\70\1\71\1\72\1\73\1\74\1\75\1\76"+
    "\1\77\1\100\1\101\1\102\1\103\1\104\1\105\2\106"+
    "\1\107\1\110\1\111\1\112\1\113\1\114\1\115\1\116"+
    "\1\117\1\120\1\121\1\122\1\123\1\124\1\125\1\126"+
    "\1\127\1\130\1\46\1\0\1\131\1\132\1\133\1\134"+
    "\1\135\1\136\3\3\1\137\1\140\1\141\1\106\1\142"+
    "\1\143\1\3\1\144\1\145\1\146";

  private static int [] zzUnpackAction() {
    int [] result = new int[134];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\74\0\170\0\264\0\360\0\u012c\0\u012c\0\u0168"+
    "\0\u01a4\0\u01e0\0\u021c\0\u0258\0\u0294\0\u02d0\0\u030c\0\u0348"+
    "\0\u012c\0\u012c\0\u0384\0\u03c0\0\u03fc\0\u012c\0\u012c\0\u012c"+
    "\0\u012c\0\u012c\0\u012c\0\u012c\0\u012c\0\u0438\0\u0474\0\u04b0"+
    "\0\u04ec\0\u012c\0\u012c\0\u012c\0\u0528\0\u0564\0\u05a0\0\u05dc"+
    "\0\u0618\0\u012c\0\u0654\0\u0690\0\u012c\0\u06cc\0\u012c\0\u0708"+
    "\0\u0744\0\u012c\0\u0780\0\u012c\0\u07bc\0\u07f8\0\u0834\0\u0870"+
    "\0\u08ac\0\u08e8\0\u012c\0\u012c\0\u012c\0\u012c\0\u012c\0\u012c"+
    "\0\u012c\0\u012c\0\u012c\0\u012c\0\u012c\0\u012c\0\u0924\0\u012c"+
    "\0\u012c\0\u012c\0\u012c\0\u012c\0\u0960\0\u099c\0\u09d8\0\u012c"+
    "\0\u012c\0\u0a14\0\u012c\0\u0a50\0\u012c\0\u012c\0\u012c\0\u012c"+
    "\0\u012c\0\u012c\0\u012c\0\u012c\0\u012c\0\u0a8c\0\u0ac8\0\u012c"+
    "\0\u012c\0\u012c\0\u012c\0\u012c\0\u012c\0\u012c\0\u012c\0\u012c"+
    "\0\u012c\0\u012c\0\u012c\0\u012c\0\u012c\0\u012c\0\u012c\0\u012c"+
    "\0\u0b04\0\u0b40\0\u0b7c\0\u012c\0\u012c\0\u012c\0\u012c\0\u012c"+
    "\0\u012c\0\u0bb8\0\u0bf4\0\u0c30\0\u012c\0\u0c6c\0\u012c\0\u012c"+
    "\0\u012c\0\u01a4\0\u0ca8\0\u01a4\0\u012c\0\u01a4";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[134];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\6\1\7\1\10\1\7\1\11\1\6\1\12\1\13"+
    "\2\11\1\13\1\14\1\11\1\15\1\6\1\13\1\16"+
    "\10\11\1\17\1\20\1\21\1\22\1\23\2\11\1\24"+
    "\2\11\1\25\1\26\1\27\1\30\1\31\1\32\1\33"+
    "\1\34\1\35\1\36\1\37\1\40\1\41\1\42\1\43"+
    "\1\44\1\45\1\46\1\47\1\50\1\11\1\6\1\7"+
    "\1\6\1\11\1\51\1\52\1\53\13\51\1\54\15\51"+
    "\1\55\37\51\1\56\1\57\1\60\13\56\1\61\14\56"+
    "\1\62\40\56\32\7\1\63\42\7\1\64\1\65\65\7"+
    "\3\6\1\7\75\0\1\7\76\0\7\11\1\0\1\11"+
    "\2\0\1\11\1\0\10\11\4\0\7\11\23\0\1\11"+
    "\2\0\2\11\6\0\1\66\1\67\1\70\1\0\1\66"+
    "\1\71\1\72\2\0\1\66\2\0\1\72\2\0\1\73"+
    "\1\0\1\74\1\75\7\0\1\74\1\0\1\75\24\0"+
    "\1\73\12\0\2\13\2\0\1\13\1\71\1\72\2\0"+
    "\1\13\2\0\1\72\2\0\1\73\1\0\1\74\1\75"+
    "\7\0\1\74\1\0\1\75\24\0\1\73\12\0\2\71"+
    "\2\0\1\71\4\0\1\71\71\0\1\76\36\0\1\77"+
    "\40\0\1\100\1\101\1\102\1\103\1\104\1\105\1\106"+
    "\1\107\23\0\1\110\50\0\1\111\1\112\21\0\1\113"+
    "\73\0\1\114\23\0\7\11\1\0\1\11\2\0\1\11"+
    "\1\0\10\11\4\0\1\11\1\115\5\11\23\0\1\11"+
    "\2\0\2\11\4\0\7\11\1\0\1\11\2\0\1\11"+
    "\1\0\10\11\4\0\4\11\1\116\2\11\23\0\1\11"+
    "\2\0\2\11\4\0\7\11\1\0\1\11\2\0\1\11"+
    "\1\0\10\11\4\0\2\11\1\117\4\11\23\0\1\11"+
    "\2\0\2\11\54\0\1\120\73\0\1\121\1\122\72\0"+
    "\1\123\1\0\1\124\71\0\1\125\73\0\1\126\6\0"+
    "\1\127\64\0\1\130\7\0\1\131\63\0\1\132\10\0"+
    "\1\133\62\0\1\134\17\0\1\51\2\0\13\51\1\0"+
    "\15\51\1\0\37\51\1\0\1\52\72\0\1\135\2\0"+
    "\3\135\1\136\3\135\1\137\3\135\1\140\1\136\13\135"+
    "\1\141\1\142\1\143\1\144\1\135\1\145\2\135\1\146"+
    "\24\135\3\0\1\147\1\56\2\0\13\56\1\0\14\56"+
    "\1\0\40\56\1\0\1\57\72\0\1\135\2\0\3\135"+
    "\1\136\3\135\1\137\3\135\1\150\1\136\13\135\1\151"+
    "\1\152\1\153\1\154\1\135\1\155\2\135\1\156\24\135"+
    "\3\0\1\157\31\0\1\64\43\0\1\64\100\0\1\66"+
    "\1\67\2\0\1\66\1\71\1\72\2\0\1\66\2\0"+
    "\1\72\5\0\1\160\11\0\1\160\37\0\2\67\2\0"+
    "\1\67\1\71\1\72\2\0\1\67\2\0\1\72\57\0"+
    "\2\161\1\0\2\161\1\0\1\161\2\0\1\161\2\0"+
    "\1\161\2\0\1\161\1\0\1\161\10\0\2\161\25\0"+
    "\1\161\3\0\1\161\6\0\2\71\2\0\1\71\1\0"+
    "\1\72\2\0\1\71\2\0\1\72\2\0\1\73\1\0"+
    "\1\74\10\0\1\74\26\0\1\73\12\0\2\162\2\0"+
    "\1\162\2\0\1\163\1\0\1\162\45\0\1\163\30\0"+
    "\1\164\1\165\1\166\1\167\1\170\1\171\50\0\7\11"+
    "\1\0\1\11\2\0\1\11\1\0\10\11\4\0\2\11"+
    "\1\172\4\11\23\0\1\11\2\0\2\11\4\0\7\11"+
    "\1\0\1\11\2\0\1\11\1\0\10\11\4\0\5\11"+
    "\1\173\1\11\23\0\1\11\2\0\2\11\4\0\7\11"+
    "\1\0\1\11\2\0\1\11\1\0\10\11\4\0\5\11"+
    "\1\174\1\11\23\0\1\11\2\0\2\11\54\0\1\175"+
    "\1\176\72\0\1\177\25\0\1\137\3\0\1\137\4\0"+
    "\1\137\62\0\1\200\3\0\1\200\4\0\1\200\62\0"+
    "\2\161\1\0\2\161\1\0\1\161\2\0\1\161\2\0"+
    "\1\161\2\0\1\161\1\0\1\161\1\201\7\0\2\161"+
    "\1\201\24\0\1\161\3\0\1\161\6\0\2\162\2\0"+
    "\1\162\4\0\1\162\5\0\1\73\1\0\1\74\10\0"+
    "\1\74\26\0\1\73\12\0\2\162\2\0\1\162\4\0"+
    "\1\162\60\0\7\11\1\0\1\202\2\0\1\11\1\0"+
    "\10\11\4\0\7\11\23\0\1\11\2\0\2\11\4\0"+
    "\7\11\1\0\1\11\2\0\1\11\1\0\1\203\7\11"+
    "\4\0\7\11\23\0\1\11\2\0\2\11\4\0\7\11"+
    "\1\0\1\11\2\0\1\11\1\0\10\11\4\0\5\11"+
    "\1\204\1\11\23\0\1\11\2\0\2\11\54\0\1\205"+
    "\23\0\7\11\1\0\1\206\2\0\1\11\1\0\10\11"+
    "\4\0\7\11\23\0\1\11\2\0\2\11";

  private static int [] zzUnpackTrans() {
    int [] result = new int[3300];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\5\0\2\11\11\1\2\11\3\1\10\11\4\1\3\11"+
    "\5\1\1\11\2\1\1\11\1\1\1\11\2\1\1\11"+
    "\1\1\1\11\2\1\2\0\1\1\1\0\14\11\1\0"+
    "\5\11\3\1\2\11\1\1\1\11\1\1\11\11\2\1"+
    "\21\11\2\1\1\0\6\11\3\1\1\11\1\1\3\11"+
    "\3\1\1\11\1\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[134];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
    StringBuffer sb = new StringBuffer();
    String file;
    String path;
    HashMap<String, Integer> keywords;
    LinkedList<Object> subst;

    public Lexer_c(String s, Position pos, Object... subst) {
        this(new EscapedUnicodeReader(new StringReader(s)));
        if (pos != null) {
            this.file = pos.toString() + ": quasiquote(" + stringSubst(s ,subst) + ")";
            this.path = pos.path();
        }
        else {
            this.file = "quasiquote(" + stringSubst(s ,subst) + ")";
            this.path = null;
        }

        this.subst = new LinkedList<Object>();
        Collections.addAll(this.subst, subst);
        this.keywords = new HashMap<String, Integer>();
        init_keywords();
    }

    private String stringSubst(String s, Object... subst) {
        StringBuffer sb = new StringBuffer();
        int substIdx = 0;
        for (int i = 0; i < s.length(); i++) {
            if (s.charAt(i) == '%' && substIdx < subst.length) {
                i++;
                sb.append(subst[substIdx++]);
            }
            else {
                sb.append(s.charAt(i));
            }
        }
        return sb.toString();
    }

    private void error(String msg, Position pos) {
       throw new InternalCompilerError(msg, pos);
    }

    protected String substKind(char kind) { return substKind(kind, false); }

    protected String substKind(char kind, boolean list) {
        switch (kind) {
            case 's': return "String";
            case 'E': return "Expr";
            case 'S': return "Stmt";
            case 'T': return "TypeNode";
            case 'D': return "ClassDecl";
            case 'M': return "ClassMember";
            case 'F': return "Formal";
            default:
                error("Bad quasiquoting substitution type: \"" + kind + "\".",
                      pos());
                return null;
        }
    }

    public Token substList(char kind) {
        if (subst.isEmpty()) {
            error("Not enough arguments to quasiquoter.", pos());
        }

        Object o = subst.removeFirst();
        String expected = substKind(kind, true);

        if (o instanceof List) {
            @SuppressWarnings("unchecked")
            List<? extends Term> l = (List<? extends Term>) o;

            for (Term p : l) {
                switch (kind) {
                    case 'E':
                        if (p instanceof Expr) continue;
                        break;
                    case 'S':
                        if (p instanceof Stmt) continue;
                        break;
                    case 'T':
                        if (p instanceof TypeNode) continue;
                        break;
                    case 'D':
                        if (p instanceof ClassDecl) continue;
                        break;
                    case 'M':
                        if (p instanceof ClassMember) continue;
                        break;
                    case 'F':
                        if (p instanceof Formal) continue;
                        break;
                    default:
                        break;
                }

                error("Bad quasiquoting substitution: expected List of " + expected + ".", pos());
            }

            return new QQListToken(pos(), l, sym.COMMA_LIST);
        }
        else {
            error("Bad quasiquoting substitution: expected List of " + expected + ".", pos());
            return null;
        }
    }

    public Token subst(char kind) {
        if (subst.isEmpty()) {
            error("Not enough arguments to quasiquoter.", pos());
        }               
                    
        Object o = subst.removeFirst();
        String expected = substKind(kind);
                    
        switch (kind) { 
            case 's': { 
                if (o instanceof String) {
                    String s = (String) o;
                    return new Identifier(pos(), s, sym.IDENTIFIER);
                }   
                break;  
            }           
            case 'E': {
                if (o instanceof Expr) { 
                    Expr e = (Expr) o;
                    return new QQNodeToken(pos(), e, sym.COMMA_EXPR);
                }       
                break;
            }
            case 'S': {                if (o instanceof Stmt) {
                    Stmt s = (Stmt) o;
                    return new QQNodeToken(pos(), s, sym.COMMA_STMT);
                }
                break;
            }
            case 'T': {                if (o instanceof TypeNode) {
                    TypeNode t = (TypeNode) o;
                    return new QQNodeToken(pos(), t, sym.COMMA_TYPE);
                }
                break;
            }
            case 'D': {
                if (o instanceof ClassDecl) {
                    ClassDecl d = (ClassDecl) o;
                    return new QQNodeToken(pos(), d, sym.COMMA_DECL);
                }
                break;
            }
            case 'M': {
                if (o instanceof ClassMember) {
                    ClassMember m = (ClassMember) o;
                    return new QQNodeToken(pos(), m, sym.COMMA_MEMB);
                }
                break;
            }
            case 'F': {
                if (o instanceof Formal) {
                    Formal f = (Formal) o;
                    return new QQNodeToken(pos(), f, sym.COMMA_FORM);
                }
                break;
            }
            default:
                // error: should be caught in substKind
                return null;
        }

        error("Bad quasiquoting substitution: expected " + expected + ".", pos());
        return null;
    }

    public Set<String> keywords() {
        if (keywords == null) {
	    keywords = new HashMap<>();
	    init_keywords();
	}

	return Collections.unmodifiableSet(keywords.keySet());
    }

    protected void init_keywords() {
        keywords.put("abstract",      new Integer(sym.ABSTRACT));
        keywords.put("assert",        new Integer(sym.ASSERT));
        keywords.put("boolean",       new Integer(sym.BOOLEAN));
        keywords.put("break",         new Integer(sym.BREAK));
        keywords.put("byte",          new Integer(sym.BYTE));
        keywords.put("case",          new Integer(sym.CASE));
        keywords.put("catch",         new Integer(sym.CATCH));
        keywords.put("char",          new Integer(sym.CHAR));
        keywords.put("class",         new Integer(sym.CLASS));
        keywords.put("const",         new Integer(sym.CONST));
        keywords.put("continue",      new Integer(sym.CONTINUE));
        keywords.put("default",       new Integer(sym.DEFAULT));
        keywords.put("do",            new Integer(sym.DO));
        keywords.put("double",        new Integer(sym.DOUBLE));
        keywords.put("else",          new Integer(sym.ELSE));
        keywords.put("extends",       new Integer(sym.EXTENDS));
        keywords.put("final",         new Integer(sym.FINAL));
        keywords.put("finally",       new Integer(sym.FINALLY));
        keywords.put("float",         new Integer(sym.FLOAT));
        keywords.put("for",           new Integer(sym.FOR));
        keywords.put("goto",          new Integer(sym.GOTO));
        keywords.put("if",            new Integer(sym.IF));
        keywords.put("implements",    new Integer(sym.IMPLEMENTS));
        keywords.put("import",        new Integer(sym.IMPORT));
        keywords.put("instanceof",    new Integer(sym.INSTANCEOF));
        keywords.put("int",           new Integer(sym.INT));
        keywords.put("interface",     new Integer(sym.INTERFACE));
        keywords.put("long",          new Integer(sym.LONG));
        keywords.put("native",        new Integer(sym.NATIVE));
        keywords.put("new",           new Integer(sym.NEW));
        keywords.put("package",       new Integer(sym.PACKAGE));
        keywords.put("private",       new Integer(sym.PRIVATE));
        keywords.put("protected",     new Integer(sym.PROTECTED));
        keywords.put("public",        new Integer(sym.PUBLIC));
        keywords.put("return",        new Integer(sym.RETURN));
        keywords.put("short",         new Integer(sym.SHORT));
        keywords.put("static",        new Integer(sym.STATIC));
        keywords.put("strictfp",      new Integer(sym.STRICTFP));
        keywords.put("super",         new Integer(sym.SUPER));
        keywords.put("switch",        new Integer(sym.SWITCH));
        keywords.put("synchronized",  new Integer(sym.SYNCHRONIZED));
        keywords.put("this",          new Integer(sym.THIS));
        keywords.put("throw",         new Integer(sym.THROW));
        keywords.put("throws",        new Integer(sym.THROWS));
        keywords.put("transient",     new Integer(sym.TRANSIENT));
        keywords.put("try",           new Integer(sym.TRY));
        keywords.put("void",          new Integer(sym.VOID));
        keywords.put("volatile",      new Integer(sym.VOLATILE));
        keywords.put("while",         new Integer(sym.WHILE));
    }

    @Override
    public String file() {
        return file;
    }

    @Override
    public String path() {
        return path;
    }

    private Position pos() {
        return new Position(path, file, yyline+1, yycolumn, yyline+1,
                            yycolumn + yytext().length());
    }

    private Position pos(int len) {
        return new Position(path, file, yyline+1, yycolumn-len-1, yyline+1,
                            yycolumn+1);
    }

    private Token key(int symbol) {
        return new Keyword(pos(), yytext(), symbol);
    }

    private Token op(int symbol) {
        return new Operator(pos(), yytext(), symbol);
    }

    private Token id() {
        return new Identifier(pos(), yytext(), sym.IDENTIFIER);
    }

    private Token int_lit(String s, int radix) {
        BigInteger x = new BigInteger(s, radix);
        boolean boundary = (radix == 10 && s.equals("2147483648"));
        int bits = radix == 10 ? 31 : 32;
        if (x.bitLength() > bits && ! boundary) {
            error("Integer literal \"" + yytext() + "\" out of range.", pos());
            return null;
        }
        return new IntegerLiteral(pos(), x.intValue(),
                boundary ? sym.INTEGER_LITERAL_BD : sym.INTEGER_LITERAL);
    }

    private Token long_lit(String s, int radix) {
        BigInteger x = new BigInteger(s, radix);
        boolean boundary = (radix == 10 && s.equals("9223372036854775808"));
        int bits = radix == 10 ? 63 : 64;
        if (x.bitLength() > bits && ! boundary) {
            error("Long literal \"" + yytext() + "\" out of range.", pos());
            return null;
        }
        return new LongLiteral(pos(), x.longValue(),
                boundary ? sym.LONG_LITERAL_BD : sym.LONG_LITERAL);
    }

    private Token float_lit(String s) {
        try {
            Float x = Float.valueOf(s);
	    boolean zero = true;
	    for (int i = 0; i < s.length(); i++) {
		if ('1' <= s.charAt(i) && s.charAt(i) <= '9') {
		    zero = false;
		    break;
		}
	    }
	    if (x.isInfinite() || x.isNaN() || (x.floatValue() == 0 && ! zero)) {
		error("Illegal float literal \"" + yytext() + "\"", pos());
		return null;
	    }
            return new FloatLiteral(pos(), x.floatValue(), sym.FLOAT_LITERAL);
        }
        catch (NumberFormatException e) {
            error("Illegal float literal \"" + yytext() + "\"", pos());
            return null;
        }
    }

    private Token double_lit(String s) {
        try {
            Double x = Double.valueOf(s);
	    boolean zero = true;
	    for (int i = 0; i < s.length(); i++) {
		if ('1' <= s.charAt(i) && s.charAt(i) <= '9') {
		    zero = false;
		    break;
		}
	    }
	    if (x.isInfinite() || x.isNaN() || (x.floatValue() == 0 && ! zero)) {
		error("Illegal double literal \"" + yytext() + "\"", pos());
		return null;
	    }
            return new DoubleLiteral(pos(), x.doubleValue(), sym.DOUBLE_LITERAL);
        }
        catch (NumberFormatException e) {
            error("Illegal double literal \"" + yytext() + "\"", pos());
            return null;
        }
    }

    private Token char_lit(String s) {
        if (s.length() == 1) {
            char x = s.charAt(0);
            return new CharacterLiteral(pos(), x, sym.CHARACTER_LITERAL);
        }
        else {
            error("Illegal character literal \'" + s + "\'", pos(s.length()));
            return null;
        }
    }

    private Token boolean_lit(boolean x) {
        return new BooleanLiteral(pos(), x, sym.BOOLEAN_LITERAL);
    }

    private Token null_lit() {
        return new NullLiteral(pos(), sym.NULL_LITERAL);
    }

    private Token string_lit() {
        return new StringLiteral(pos(sb.length()), sb.toString(),
                                 sym.STRING_LITERAL);
    }

    private String chop(int i, int j) {
        return yytext().substring(i,yylength()-j);
    }

    private String chop(int j) {
        return chop(0, j);
    }

    private String chop() {
        return chop(0, 1);
    }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public Lexer_c(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 2272) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

    // numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public Token nextToken() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn++;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 1: 
          { error("Illegal character \"" +
                                              yytext() + "\"", pos());
          }
        case 103: break;
        case 2: 
          { /* ignore */
          }
        case 104: break;
        case 3: 
          { Integer i = keywords.get(yytext());
                    if (i == null) return id();
                    else return key(i.intValue());
          }
        case 105: break;
        case 4: 
          { Token t = int_lit(yytext(), 10);
                                   if (t != null) return t;
          }
        case 106: break;
        case 5: 
          { return op(sym.DOT);
          }
        case 107: break;
        case 6: 
          { return op(sym.MINUS);
          }
        case 108: break;
        case 7: 
          { return op(sym.MOD);
          }
        case 109: break;
        case 8: 
          { return op(sym.DIV);
          }
        case 110: break;
        case 9: 
          { return op(sym.MULT);
          }
        case 111: break;
        case 10: 
          { yybegin(CHARACTER); sb.setLength(0);
          }
        case 112: break;
        case 11: 
          { yybegin(STRING); sb.setLength(0);
          }
        case 113: break;
        case 12: 
          { return op(sym.LPAREN);
          }
        case 114: break;
        case 13: 
          { return op(sym.RPAREN);
          }
        case 115: break;
        case 14: 
          { return op(sym.LBRACE);
          }
        case 116: break;
        case 15: 
          { return op(sym.RBRACE);
          }
        case 117: break;
        case 16: 
          { return op(sym.LBRACK);
          }
        case 118: break;
        case 17: 
          { return op(sym.RBRACK);
          }
        case 119: break;
        case 18: 
          { return op(sym.SEMICOLON);
          }
        case 120: break;
        case 19: 
          { return op(sym.COMMA);
          }
        case 121: break;
        case 20: 
          { return op(sym.EQ);
          }
        case 122: break;
        case 21: 
          { return op(sym.GT);
          }
        case 123: break;
        case 22: 
          { return op(sym.LT);
          }
        case 124: break;
        case 23: 
          { return op(sym.NOT);
          }
        case 125: break;
        case 24: 
          { return op(sym.COMP);
          }
        case 126: break;
        case 25: 
          { return op(sym.QUESTION);
          }
        case 127: break;
        case 26: 
          { return op(sym.COLON);
          }
        case 128: break;
        case 27: 
          { return op(sym.AND);
          }
        case 129: break;
        case 28: 
          { return op(sym.OR);
          }
        case 130: break;
        case 29: 
          { return op(sym.PLUS);
          }
        case 131: break;
        case 30: 
          { return op(sym.XOR);
          }
        case 132: break;
        case 31: 
          { sb.append( yytext() );
          }
        case 133: break;
        case 32: 
          { yybegin(YYINITIAL);
                                   error("Unclosed string literal",
                                              pos(sb.length()));
          }
        case 134: break;
        case 33: 
          { yybegin(YYINITIAL);
                                   return string_lit();
          }
        case 135: break;
        case 34: 
          { yybegin(YYINITIAL);
                                  error("Unclosed character literal",
                                             pos(sb.length()));
          }
        case 136: break;
        case 35: 
          { yybegin(YYINITIAL);
                                   Token t = char_lit(sb.toString());
                                   if (t != null) return t;
          }
        case 137: break;
        case 36: 
          { yybegin(YYINITIAL);
          }
        case 138: break;
        case 37: 
          { Token t = int_lit(yytext(), 8);
                                   if (t != null) return t;
          }
        case 139: break;
        case 38: 
          { Token t = double_lit(yytext());
                                   if (t != null) return t;
          }
        case 140: break;
        case 39: 
          { Token t = double_lit(chop());
                                   if (t != null) return t;
          }
        case 141: break;
        case 40: 
          { Token t = float_lit(chop());
                                   if (t != null) return t;
          }
        case 142: break;
        case 41: 
          { Token t = long_lit(chop(), 10);
                                   if (t != null) return t;
          }
        case 143: break;
        case 42: 
          { return op(sym.MINUSMINUS);
          }
        case 144: break;
        case 43: 
          { return op(sym.MINUSEQ);
          }
        case 145: break;
        case 44: 
          { return subst('s');
          }
        case 146: break;
        case 45: 
          { return subst('E');
          }
        case 147: break;
        case 46: 
          { return subst('S');
          }
        case 148: break;
        case 47: 
          { return subst('T');
          }
        case 149: break;
        case 48: 
          { return subst('D');
          }
        case 150: break;
        case 49: 
          { return subst('M');
          }
        case 151: break;
        case 50: 
          { return subst('F');
          }
        case 152: break;
        case 51: 
          { return op(sym.MODEQ);
          }
        case 153: break;
        case 52: 
          { yybegin(END_OF_LINE_COMMENT);
          }
        case 154: break;
        case 53: 
          { yybegin(TRADITIONAL_COMMENT);
          }
        case 155: break;
        case 54: 
          { return op(sym.DIVEQ);
          }
        case 156: break;
        case 55: 
          { return op(sym.MULTEQ);
          }
        case 157: break;
        case 56: 
          { return op(sym.EQEQ);
          }
        case 158: break;
        case 57: 
          { return op(sym.GTEQ);
          }
        case 159: break;
        case 58: 
          { return op(sym.RSHIFT);
          }
        case 160: break;
        case 59: 
          { return op(sym.LTEQ);
          }
        case 161: break;
        case 60: 
          { return op(sym.LSHIFT);
          }
        case 162: break;
        case 61: 
          { return op(sym.NOTEQ);
          }
        case 163: break;
        case 62: 
          { return op(sym.ANDEQ);
          }
        case 164: break;
        case 63: 
          { return op(sym.ANDAND);
          }
        case 165: break;
        case 64: 
          { return op(sym.OREQ);
          }
        case 166: break;
        case 65: 
          { return op(sym.OROR);
          }
        case 167: break;
        case 66: 
          { return op(sym.PLUSEQ);
          }
        case 168: break;
        case 67: 
          { return op(sym.PLUSPLUS);
          }
        case 169: break;
        case 68: 
          { return op(sym.XOREQ);
          }
        case 170: break;
        case 69: 
          { error("Illegal escape character \"" +
                                              yytext() + "\"", pos());
          }
        case 171: break;
        case 70: 
          { try {
                                       int x = Integer.parseInt(chop(1,0), 8);
                                       sb.append((char) x);
                                   }
                                   catch (NumberFormatException e) {
                                       error("Illegal octal escape \""
                                                  + yytext() + "\"", pos());
                                   }
          }
        case 172: break;
        case 71: 
          { sb.append( '\\' );
          }
        case 173: break;
        case 72: 
          { sb.append( '\'' );
          }
        case 174: break;
        case 73: 
          { sb.append( '\"' );
          }
        case 175: break;
        case 74: 
          { sb.append( '\t' );
          }
        case 176: break;
        case 75: 
          { sb.append( '\r' );
          }
        case 177: break;
        case 76: 
          { sb.append( '\f' );
          }
        case 178: break;
        case 77: 
          { sb.append( '\n' );
          }
        case 179: break;
        case 78: 
          { sb.append( '\b' );
          }
        case 180: break;
        case 79: 
          { sb.append('\\');
          }
        case 181: break;
        case 80: 
          { sb.append('\'');
          }
        case 182: break;
        case 81: 
          { sb.append('\"');
          }
        case 183: break;
        case 82: 
          { sb.append('\t');
          }
        case 184: break;
        case 83: 
          { sb.append('\r');
          }
        case 185: break;
        case 84: 
          { sb.append('\f');
          }
        case 186: break;
        case 85: 
          { sb.append('\n');
          }
        case 187: break;
        case 86: 
          { sb.append('\b');
          }
        case 188: break;
        case 87: 
          { Token t = long_lit(chop(), 8);
                                   if (t != null) return t;
          }
        case 189: break;
        case 88: 
          { Token t = int_lit(chop(2,0), 16);
                                   if (t != null) return t;
          }
        case 190: break;
        case 89: 
          { return substList('E');
          }
        case 191: break;
        case 90: 
          { return substList('S');
          }
        case 192: break;
        case 91: 
          { return substList('T');
          }
        case 193: break;
        case 92: 
          { return substList('D');
          }
        case 194: break;
        case 93: 
          { return substList('M');
          }
        case 195: break;
        case 94: 
          { return substList('F');
          }
        case 196: break;
        case 95: 
          { return op(sym.RSHIFTEQ);
          }
        case 197: break;
        case 96: 
          { return op(sym.URSHIFT);
          }
        case 198: break;
        case 97: 
          { return op(sym.LSHIFTEQ);
          }
        case 199: break;
        case 98: 
          { Token t = long_lit(chop(2,1), 16);
                                   if (t != null) return t;
          }
        case 200: break;
        case 99: 
          { return boolean_lit(true);
          }
        case 201: break;
        case 100: 
          { return null_lit();
          }
        case 202: break;
        case 101: 
          { return op(sym.URSHIFTEQ);
          }
        case 203: break;
        case 102: 
          { return boolean_lit(false);
          }
        case 204: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
              {     return new EOF(pos(), sym.EOF);
 }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
