/*******************************************************************************
 * This file is part of the Polyglot extensible compiler framework.
 *
 * Copyright (c) 2000-2012 Polyglot project group, Cornell University
 * Copyright (c) 2006-2012 IBM Corporation
 * All rights reserved.
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * This program and the accompanying materials are made available under
 * the terms of the Lesser GNU Public License v2.0 which accompanies this
 * distribution.
 *
 * The development of the Polyglot project has been supported by a
 * number of funding sources, including DARPA Contract F30602-99-1-0533,
 * monitored by USAF Rome Laboratory, ONR Grants N00014-01-1-0968 and
 * N00014-09-1-0652, NSF Grants CNS-0208642, CNS-0430161, CCF-0133302,
 * and CCF-1054172, AFRL Contract FA8650-10-C-7022, an Alfred P. Sloan
 * Research Fellowship, and an Intel Research Ph.D. Fellowship.
 *
 * See README for contributors.
 ******************************************************************************/

package polyglot.ast;

import java.util.StringTokenizer;

import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.PrettyPrinter;

/**
 * An Immutable representation of a Javadoc
 */
public class Javadoc_c extends Node_c implements Javadoc {
    private static final long serialVersionUID = SerialVersionUID.generate();

    private String text;

    public Javadoc_c(Position pos, String text) {
        super(pos, null);
        this.text = text;
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter pp) {
        // Avoid messing up the pretty printer.
        String whitespace = " \t";
        String linebreak = "\n\r\f";
        StringTokenizer tokenizer =
                new StringTokenizer(text, whitespace + linebreak, true);
        boolean ignoreSpace = false;
        w.begin(0);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (linebreak.contains(token)) {
                w.newline();
                ignoreSpace = true;
            }
            else if (whitespace.contains(token)) {
                if (!ignoreSpace) w.allowBreak(1, token);
            }
            else {
                if (ignoreSpace) {
                    w.write(" ");
                    ignoreSpace = false;
                }
                w.write(token);
            }
        }
        w.end();
        w.newline();
    }

    @Override
    public String getText() {
        return text;
    }
}
