function [ img ] = pao_imread(fname, must_fail)
% must_fail: trhow exception, used to force recomputation of data

if ~exist('must_fail', 'var')
    must_fail = 0;
end

if must_fail
    error('ERROR: Must fail is true when reading file %s', fname)
end

[p n e] = fileparts(fname);

switch e
    case '.exr'
        img = exrread(fname);
    otherwise
        img = im2double(imread(fname));
end

if size(img,3) == 1
    img = repmat(img, [1 1 3]);
end
       
end