function [ kappa ] = pao_compute_kappa_sb(f, alpha)
% Single bounce model for kappa

kappa = zeros([size(alpha,1), size(alpha,2), length(f)]);

for i = 1:length(f)
    
    nom = 3 * (1 + 2 * f(i) * pi)^2 .* sin(alpha).^4;
    den = 4 * (1 - cos(alpha).^3 + 3 * f(i) * pi * (1 + f(i) * pi) * sin(alpha).^4) + 1e-4;
    
    kappa(:,:,i) = nom ./ den;
end

end
