function [ f, alpha ] = pao_alpha_initial_estimate( kappa, mask )

if ~exist('mask', 'var')
    mask = [];
else
    mask = mask(:,:,1);
end

kmag_thresh = 0.005;

% Estimate values for f
f = zeros(size(kappa,3),1);
kappa_max = zeros(size(kappa,3),1);
for i = 1:length(f)
    % We should not consider the kappa value around depth discontinuities,
    % since our model does not explain these regions
    [kdx kdy] = pao_gradient(kappa(:,:,i), 3);
    kmag = sqrt(kdx.^2 + kdy.^2);
    sel = kmag < kmag_thresh;

    if ~isempty(mask)
        sel(mask == 0) = 0;
    end
            
    if false % old way of selecting max k
        kappa_max(i) = min(0.999, max(reshape(kappa(:,:,i), 1, [])));
    else
        kappa_aux = kappa(:,:,i);
        kappa_max(i) = min(0.999, max(reshape(kappa_aux(sel),[],1)));
    end
    
    if false
        old_kappa_max = min(0.999, max(reshape(kappa(:,:,i), 1, [])));

        fprintf('>> Old Kmax = %f\n', old_kappa_max);
        fprintf('>> New Kmax = %f\n', kappa_max(i));
        
        subplot(3,2, (i - 1) * 2 + 1)
        
        imshow(kappa(:,:,i) .* sel,[])
        hold on
        idx = find(kappa(:,:,i) == old_kappa_max);
        [y x] = ind2sub(size(kmag), idx);
        plot(x, y, 'rx', 'MarkerSize', 20)
        
        kmag_aux = kmag;
        kmag_aux(kmag >= kmag_thresh) = min(kmag(:));
        
        idx = find(kappa(:,:,i) == kappa_max(i));
        [y x] = ind2sub(size(kmag), idx);
        plot(x, y, 'g+', 'MarkerSize', 20)
        
        subplot(3,2, (i - 1) * 2 + 2);
        %imshow(avg(:,:,i))
        
        pause
    end
        
    f(i) = ( sqrt(3.0) * sqrt(kappa_max(i) * (1 - kappa_max(i))) + 3 * kappa_max(i) - 3 ) /(6 * pi * (1 - kappa_max(i)) );
end

if true
    kappa_max(:) = 0.75;
    kappa = kappa_max(1) * kappa;
    f = ( sqrt(3.0) * sqrt(kappa_max .* (1 - kappa_max)) + 3 * kappa_max - 3 ) ./(6 * pi * (1 - kappa_max));
end

% Compute mapping kappa -> alpha
n_samples = 1000;
kappa2alpha = zeros(n_samples, length(f));

for i = 1:length(f)
    a = linspace(0, pi / 2, n_samples);
    
    r_of_a = pao_compute_kappa(f(i), a);
    r_of_a(1) = 0;
    
    r = linspace(0, kappa_max(i), n_samples);
    for j = 1:length(r)
        idx = find(r(j) >= r_of_a, 1, 'last' );
        kappa2alpha(j,i) = a(idx);
    end
end

% Now compute the alpha's
alpha = zeros(size(kappa,1), size(kappa,2), length(f));
for i = 1:length(f)
    
    idxs = round((n_samples - 1) * kappa(:,:,i) / kappa_max(i)) + 1;
    idxs = min(idxs, n_samples);
    
    tmp = kappa2alpha(:, i);
    alpha(:,:,i) = tmp(idxs);
end

alpha = sum(alpha,3)/3;

end
