%% Get image filenames
img_fnames = pao_dir('data/*.jpg');
gamma = 1.0; % Gamma used for inverse tone mapping

%% Compute image statistics
[ kappa, img_avg, img2_avg ] = pao_compute_kappa_imgs(img_fnames, gamma);

%% 1st Estimate: f assumed 0

% Compute albedo and alpha image
[f alpha_1est] = pao_alpha_initial_estimate( kappa );
amboc_1est = pao_alpha2amboc(alpha_1est);

% Albedo
albedo_1est = pao_compute_albedo(img_avg, alpha_1est, f');

%% 2nd Estimate: Non linear optimization corrects for f
%  This stage only makes sense if there is an ambient light source in the
%  scene.
    
[f alpha_2est] = pao_alpha_nonlinear_opt(kappa, f, alpha_1est, img_avg);

% Ambient Occlusion
amboc_2est = pao_alpha2amboc(alpha_2est);
    
% Albedo
albedo_2est = pao_compute_albedo(img_avg, alpha_2est, f');

%% Estimate L for an image
        
img = pao_imread(img_fnames{21});
    
lum_1est = img ./ max(realmin('double'), albedo_1est);
lum_2est = img ./ max(realmin('double'), albedo_2est);

%% Show results
subplot(2,4,[1 5])
imshow(img)
title('Image')

subplot(2,4,2)
imshow(amboc_1est)
title('Ambient Occlusion 1est')

subplot(2,4,3)
imshow(albedo_1est)
title('Albedo 1est')

subplot(2,4,4)
imshow(lum_1est)
title('Illumination 1est')

subplot(2,4,6)
imshow(amboc_2est)
title('Ambient Occlusion 2est')

subplot(2,4,7)
imshow(albedo_2est)
title('Albedo 2est')

subplot(2,4,8)
imshow(lum_2est)
title('Illumination 2est')

