(* ***************************************************************************
 
   $Source: /cvsroot/katml/Src/sml_tk/src/root_mosml.sml,v $
 
   PolyML root file. (Known to run with MoscowML 2.00.)
  
   $Date: 2004/06/29 16:38:29 $
   $Revision: 1.1.1.1 $
   Author: cxl (Last modification by $Author: kamal $)

   (C) 2001, Universitaet Freiburg
 
  ************************************************************************** *)

(* First load all required structures ("units") *)

load "Int";
load "Substring";
load "String";
load "Unix";
load "OS";
load "Process";
load "ListPair";
load "IO";
load "Date";
load "Time";
load "Bool";
load "CommandLine";
load "Timer";
load "Real";

(* load "Posix"; can't find that-- hence this: *)

structure Posix =
    struct 
	structure Process =
	struct fun sleep x = x end 
        structure ProcEnv =
	struct fun getlogin () = "unknown" 
	       fun getuid() = ~1  end
	structure SysDB =
	struct fun getpwuid _ = "unknown"
               structure Passwd = struct fun name _ = "unknown" end end
	   
    end;

(* OS.FileSys.readDir has a different type in MoscowML's basis, hence this: *)
structure OS =
    struct open OS
        structure FileSys= 
            struct 
                open FileSys
                val readDir= fn ds=> Option.getOpt(readDir ds, "")
            end 
    end; 




(* use Moscow-ML specific file *)
use "sys_dep.sig";
use "mosml.sml";

(* Then use CM-produced root file *)
use "root.sml";



(* Here's how to produce root.sml from inside SML/NJ: 

CM.mkusefile "root.sml";

Of course, in there we need to delete njml.sml 
and sys_dep.sig.
*)
