(* ***************************************************************************

   $Source: /cvsroot/katml/Src/sml_tk/src/eventloop.sig,v $

   sml_tk event handler.

   This module implements the sml_tk event handling mechanism. It exports
   two functions, startTcl and startTclExn, which take a list of windows
   and start the GUI main application loop (where the Exn variant handles
   all exceptions which might occur). 

   $Date: 2004/06/29 16:38:29 $
   $Revision: 1.1.1.1 $

   Author: bu (Last modification $Author: kamal $)

   (C) 1996-99, Bremen Institute for Safe Systems, Universitaet Bremen
 
  ************************************************************************** *)

signature EVENTLOOP =
    sig

	val startTcl    : BasicTypes.Window list -> unit
	val startTclExn : BasicTypes.Window list -> string

	(* Interrupt handling *)
	type intr_listener 	
	val registerIntrListener   : (unit-> unit)-> intr_listener
	val deregisterIntrListener : intr_listener-> unit

    end
