signature PROOF = sig

  type direction = Util.direction
  type term = Term.term
  type eqn = Term.eqn
  type cond_eqn = Term.cond_eqn
  type id = Term.id
  type substitution = Term.substitution
  type C = SLang.C
  type fosubstitution = (C * term) list
  type xml = XML.xml

  datatype proof =
    LAMBDAS of (id list) * proof
  | LAMBDAP of (id list) * proof
  | APPLYS of proof * substitution
  | APPLYF of proof * fosubstitution
  | APPLYP of proof * proof list
  | VAR of id
  | TASK of id * (cond_eqn * proof list * int list)
  | CONST of id
  | AXIOM of id
  | SUBST of int list * eqn * direction * proof * proof

  type task = id * (cond_eqn * proof list * int list)
  type theorem = id * (cond_eqn * task option ref * proof ref)


  (* Get list of tasks from a proof *)
  val getTasks : proof -> task list
 
  (* Convert XML to proof *)
  val proofFromXML : xml -> proof

  (* Convert proof to string *)
  val toString : proof -> string

end