#/bin/bash
SML_INSTALL_PATH=`which sml`
if [ "$SML_INSTALL_PATH" = "" ]; then
   echo "SML cannot be found.  Please download and install (http://www.smlnj.org)"
   exit
fi

echo "Where would you like to install KAT-ML? (default: /usr/local/katml)"
read LOCATION
if [ "$LOCATION" = "" ]; then
   LOCATION = "/usr/local/katml"
fi

mkdir -p $LOCATION
mkdir "$LOCATION/Bin"

OPTIONS="CommandLine Graphical"
select opt in $OPTIONS; do
    if [ "$opt" = "CommandLine" ]; then
     cp KAT.* "$LOCATION/Bin"
     cp kat-cli.sh "$LOCATION/Bin/kat.sh"
     cp -R Lib LaTeX README.rtf TODO.txt kat.ini FIRSTORDER.rtf REDUCTIONS.rtf Examples "$LOCATION"
     exit
    elif [ "$opt" = "Graphical" ]; then

    TK_INSTALL_PATH=`which wish`
    if [ "$TK_INSTALL_PATH" = "" ]; then
    echo "Tcl/Tk cannot be found.  Please download and install (http://www.tcl.tk)"
    exit
    fi

     cp KAT_TK* "$LOCATION/Bin"
     echo "#/bin/bash" > "$LOCATION/Bin/kat.sh"
     echo "export SMLTK_TCL=$TK_INSTALL_PATH" >> "$LOCATION/Bin/kat.sh"
     echo "export SMLTK_LIB=../tklib/" >> "$LOCATION/Bin/kat.sh"
     echo "sml @SMLload=KAT_TK" >> "$LOCATION/Bin/kat.sh"
     chmod 755 "$LOCATION/Bin/kat.sh"
     cp -R tklib "$LOCATION"
     cp -R Lib LaTeX README.rtf TODO.txt kat.ini FIRSTORDER.rtf REDUCTIONS.rtf Examples "$LOCATION"
     exit
    else
      clear
      echo Bad Option
    fi
done