
open Ast

module E = Equations_types

let print (v : expr) : expr =
  match v with
    | Strg s -> Printf.printf "%s" s; Unit
    | Int n -> Printf.printf "%d" n; Unit
    | Bool b -> Printf.printf "%B" b; Unit
    | _ -> 
      print_string( Printing.to_string (v, Environment.Environment.empty));
      Unit
    (*| _ -> Ast.runtime "don't know how to print this"*)

let float_of_int2 (i : expr) : expr = match i with
  | Int(j) -> Float(float_of_int j)
  | _ -> Ast.runtime "Native float_of_int failed"
 
let string_of_int2 (i: expr) : expr = match i with
  | Int(j) -> Strg(string_of_int j)
  | _ -> Ast.runtime "Native string_of_int failed"

exception Failwith of string
let failwith2 (a:expr) : expr = match a with
  | Strg(s) -> raise (Failwith s)
  | _ -> Ast.runtime "Native failwith failed"

let natives = [
  ("print", print, let t = E.newVar() in Arrow (t, UnitType));
  ("float_of_int", float_of_int2, Arrow(Integer, FloatType));
  ("string_of_int", string_of_int2, Arrow(Integer, String));
  ("failwith", failwith2, let t = E.newVar() in Arrow(String, t))
]
