(* Examples showing that we cannot compare elements
   just by physical equality when constructing
   the equations *)

let one = [ 1 ]
let two = [ 1; 2 ]
let rec zeros = 0 :: zeros
let rec ones = 1 :: ones
let rec alt = 1 :: 2 :: alt
let rec alt3 = 1 :: 2 :: 3 :: alt3

(* Equality of lists *)
let corec[appears(false)] equal_aux arg = match arg with
  [], [] -> true
| h1 :: t1, h2 :: t2 -> (h1 = h2) && equal_aux (t1, t2)
| x -> false

let equal arg = not(equal_aux arg)

let r61 = equal (zeros, zeros) 
let r62 = equal (zeros, ones) 

(* Descending chains 
   Example of Venanzio Capretta *)
let corec[constructor] descending_aux arg = match arg with
    n, i :: j :: t -> if i > j 
      then descending_aux (n+1, j :: t)
      else n :: descending_aux (1, j :: t)
  | x -> failwith "Error: finite lists not allowed"

let descending arg = descending_aux (1, arg)

let r63 = descending zeros
let r64 = descending ones
let r65 = descending alt
let r66 = descending alt3

let corec[constructor] descending2_aux arg = match arg with
    n, i :: ti -> (match ti with
      j :: tj -> if i > j
        then descending2_aux (n+1, ti)
        else n :: descending2_aux (1, ti))
  | x -> failwith "Error: finite lists not allowed"

let descending2 arg = descending2_aux (1, arg)

let r67 = descending2 zeros
let r68 = descending2 ones
let r69 = descending2 alt
let r70 = descending2 alt3

