type tree = Heads | Tails | Flip of float * tree * tree

(**** Probability of Heads ****)

let corec[gaussian] probability t = match t with
  (* computes the final probability of Heads *)
    Heads -> 1.
  | Tails -> 0.
  | Flip(p, t1, t2) ->
    p *. probability t1 +. (1. -. p) *. probability t2

let r1 = probability (Heads)
let r2 = probability (Tails)
let r3 = probability (Flip(0.3, Heads, Tails))
let r4 = probability (Flip(0.3, Tails, Heads))

let rec coin0 = Flip(0.4, Heads, Flip(0.3, Tails, coin0))
let r5 = probability coin0

let rec coin1 = Flip(0.5, Heads, Flip(0.5, Tails, coin1))
let r6 = probability coin1


(**** Expected number of flips ****)

let corec[gaussian] flips t = match t with
    Heads -> 0. | Tails -> 0.
  | Flip(p, t1, t2) -> 1. +. p *. (flips t1) +. (1. -. p) *. (flips t2)

let r7 = flips (Heads)
let r8 = flips (Tails)
let r9 = flips (Flip(0.3, Heads, Tails))
let r10 = flips (Flip(0.3, Tails, Heads))

let r11 = flips coin0
let r12 = flips coin1

