type number  = Int of int | Var of string | Plus of boolean * boolean
type command = Skip | Assign of string * number | Cons of command * command
             | If of number * command * command | While of number * command

type anumber = APos | ANeg | AZero | ATop
(* type astore  = (string * anumber) list *)

let string_of_aboolean ab = match ab with
    APos -> "APos" | ANeg -> "ANeg" | AZero -> "AZero" | ATop -> "ATop"
let string_of_astore s = "[ " ^
  ( string_concat " ; " 
      (map (fun p -> match p with
	  (a, b) -> (a ^ " : " ^ (string_of_aboolean b))) s) ) ^ " ]"

let print_astore s = print (string_of_astore s); print "\n"

let join an1 an2 = if an1 = an2 then an1 else ATop

let rec interpret_number (n:number) s : anumber = match n with
    Int i -> if i<0 then ANeg else if i=0 then AZero else APos
  | Var x -> assoc x s
  | Plus(n1, n2) -> 
    match interpret_number n1 s, interpret_number n2 s with
	AZero, an2 -> an2
      | an1, AZero -> an1
      | an1, an2 -> join an1 an2

let rec insert (p: 'a * 'b) (l: ('a * 'b) list) = 
  (* list sorted from smallest to largest *)
  match p, l with
      (a, b), [] -> [a, b]
    | (a, b), (c, d) :: t ->
      if a = c then (a, b) :: t 
      else if a < c then (a, b) :: l
      else (c, d) :: insert (a, b) t

let rec join_env e1 e2 = 
  match e1, e2 with
    [], e2 -> e2
  | e1, [] -> e1
  | (x1, b1) :: t1, (x2, b2) :: t2 ->
    if x1 = x2 then (x1, join b1 b2) :: join_env t1 t2
    else if x1 < x2 then (x1, b1) :: join_env t1 e2
    else (x2, b2) :: join_env e1 t2

(* Version that explicitly forbids nested while loops *)
let rec interpret0 (c:command) s = match c with
    Skip -> s | Cons(c1, c2) -> interpret0 c2 (interpret0 c1 s)
  | Assign(x, n) -> insert (x, interpret_number n s) s
  | If(n, c1, c2) -> (
    match interpret_number n s with
	APos -> interpret0 c1 s
      | ANeg -> interpret0 c1 s
      | AZero -> interpret0 c2 s
      | ATop -> join_env (interpret0 c1 s) (interpret0 c2 s) )
  | While(b, c) -> failwith "Nested while loops not allowed"
let corec[iterator([])] interpret_while arg =
  match arg with (s, b, c) ->
  match interpret_number b s with
      APos -> s | ANeg -> s
    | an -> join_env s (interpret_while (interpret0 c s, b, c))
let rec interpret1 (c:command) s = match c with
    Skip -> s | Cons(c1, c2) -> interpret1 c2 (interpret1 c1 s)
  | Assign(x, n) -> insert (x, interpret_number n s) s
  | If(n, c1, c2) -> (
    match interpret_number n s with
	APos -> interpret1 c1 s
      | ANeg -> interpret1 c1 s
      | AZero -> interpret1 c2 s
      | ATop -> join_env (interpret1 c1 s) (interpret1 c2 s) )
  | While(b, c) -> interpret_while (s, b, c)

let r1 = [ "x", APos; "y", ANeg ] 
let r2 = interpret1 (While(Var "b", Assign("b", Int 1))) ["b", ANeg]
let r3 = interpret1 (While(Var "b", Assign("b", Int 1))) ["b", AZero]
let r4 = interpret1 (Assign("b", Int 0)) ["b", AZero]
let r5 = interpret1 (Assign("b", Int 1)) ["b", AZero]
let r6 = interpret1 (Assign("b", Int (-1))) ["b", AZero]
let r7 = interpret1 (While(Var "b", Assign("b", Int 0))) ["b", AZero]

(* The real version *)
let rec interpret (c:command) s = match c with
    Skip -> s | Cons(c1, c2) -> interpret c2 (interpret c1 s)
  | Assign(x, n) -> insert (x, interpret_number n s) s
  | If(n, c1, c2) -> (
    match interpret_number n s with
	APos -> interpret c1 s
      | ANeg -> interpret c1 s
      | AZero -> interpret c2 s
      | ATop -> join_env (interpret c1 s) (interpret c2 s) )
  | While(b, c) ->
    let corec[iterator([])] interpret_while s =
      match interpret_number b s with
	  APos -> s | ANeg -> s
	| an -> join_env s (interpret_while (interpret c s))
    in interpret_while s

let r8 = [ "x", APos; "y", ANeg ] 
let r9 = interpret (While(Var "b", Assign("b", Int 1))) ["b", ANeg]
let r10 = interpret (While(Var "b", Assign("b", Int 1))) ["b", AZero]
let r11 = interpret (Assign("b", Int 0)) ["b", AZero]
let r12 = interpret (Assign("b", Int 1)) ["b", AZero]
let r13 = interpret (Assign("b", Int (-1))) ["b", AZero]
let r14 = interpret (While(Var "b", Assign("b", Int 0))) ["b", AZero]

