(* A little bit ad hoc *)

open Ast

let rec remove_beginning l pref = match l, pref with
  (* pref should be a prefix of l *)
  | _, [ ] -> l
  | hl :: tl, hp :: tp when hl = hp -> remove_beginning tl tp
  | _ -> failwith "pref not a prefix of l"

let rec solve_aux name eqs (seen : (id * int list) list) (sofar : int list) =
  try let e = List.rev (List.assoc name seen) in
    e, remove_beginning (List.rev sofar) e
  with Not_found -> match List.assoc name eqs with
    | Inj("I1", None) -> List.rev sofar, [ ]
    | Inj("I2", Some(Tuple [Int i; Unknown name2])) -> 
        let res = i :: sofar in
        solve_aux name2 eqs ((name, sofar) :: seen) res
    | e -> print_string(Printing.to_string (e, Environment.Environment.empty)); 
           failwith "Separate error"

let rec list_to_lis = function
| [ ] -> Inj("N", None)
| i :: t -> Inj("C", Some(Tuple [ Int i; list_to_lis t ]))

let solve name env eqs = 
  let res1, res2 = solve_aux name eqs [ ] [ ]
  in Inj("I3", Some (Tuple [ list_to_lis res1 ; list_to_lis res2 ])), env
