module type SOLVER =
sig
  type variable = string

  type 'b f
  val fh : ('c * 'e -> 'a * 'e) -> 'c f * 'e -> 'a f * 'e (* bind?? *)

  type equation = variable * (variable f)
  type coalgebra
  type algebra

  val equal : coalgebra -> coalgebra -> bool

  val gamma : coalgebra -> coalgebra f
  (* val alpha : algebra f -> algebra *)
    
  val solve : variable -> equation list -> algebra
end

(* cannot get it to pass the syntax check *)
(*
module Corecursive2 =
  functor (S : SOLVER) ->
    sig
      val main : S.coalgebra -> S.algebra
    end;;
*)
(* Building equations *)
module Corecursive =
  functor (S : SOLVER) ->
    struct
    let fresh =
      let c = ref 0 in
      fun () -> c := !c +1; "var" ^ (string_of_int !c)
    
    let option_get = function
      | None -> failwith "No value"
      | Some(a) -> a
    
    let rec assq x = function
      (* Same as List.assoc, but using S.equal for equality *)
      | (y, a):: tl when S.equal x y -> a
      | hd:: tl -> assq x tl
      | [] -> raise Not_found
    
    let rec equations_aux (c: S.coalgebra) (eqs: S.equation list)
        (seen: (S.coalgebra * S.variable) list)
    : S.variable * (S.equation list) * ((S.coalgebra * S.variable) list) =
      try let name = assq c seen in name, eqs, seen
      with Not_found ->
          let name = fresh () in
          let seen0 = (c, name):: seen in
          let eq_rhs, (eqs2, seen2) =
            S.fh (fun (c1, (eqs1, seen1)) ->
                    let _, eqs2, seen2 = equations_aux c1 eqs1 seen1 in
                    assq c1 seen2, (eqs2, seen2))
              (S.gamma c, (eqs, seen0)) in
          name, (name, eq_rhs):: eqs2, seen2
    
    let equations (c: S.coalgebra) : S.variable * (S.equation list) =
      let name, eqs, _ = equations_aux c [] [] in
      name, eqs

    let main (c: S.coalgebra) : S.algebra =
      let name, eqs = equations c in
      S.solve name eqs
  end;;


