
open Ast

module E = Equations_types

let hd (v : expr) : expr =
  match v with
    | List l ->
      (match l with
        | [] -> Eval.runtime "head of empty list"
        | x :: _ -> x)
    | _ -> Eval.runtime "head of non-list"

let tl (v : expr) : expr =
  match v with
    | List l ->
      (match l with
        | [] -> Eval.runtime "tail of empty list"
        | _ :: t -> List t)
    | _ -> Eval.runtime "tail of non-list"

let print (v : expr) : expr =
  match v with
    | Strg s -> Printf.printf "%s" s; Unit
    | Int n -> Printf.printf "%d" n; Unit
    | Bool b -> Printf.printf "%B" b; Unit
    | _ -> Eval.runtime "don't know how to print this"

let natives = [
  ("hd", hd, let t = E.newVar() in Arrow (ListType t, t));
  ("tl", tl, let t = E.newVar() in Arrow (ListType t, ListType t));
  ("print", print, let t = E.newVar() in Arrow (t, UnitType))
]