(* utility functions *)

(* generate printable names for the elements of a list *)
let next_name = ref 0
let name x = let n = string_of_int !next_name in incr next_name; n
let names l = List.map name l

let print_int n = print_endline (string_of_int n)
  
(* List.memq but with defined equality *)
let rec memq (equal : 'x -> 'x -> bool) (x : 'x) : 'x list -> bool =
  List.exists (equal x)

(* List.assq but with defined equality *)
let rec assq (equal : 'x -> 'x -> bool) (l : ('x * 'y) list) (x : 'x) : 'y =
  match l with
    | [] -> raise Not_found
    | (y, a) :: t -> if equal x y then a else assq equal t x
  
let print_values (v : string list) (t : string list) =
  List.iter2 (Printf.printf "%s=%s ") v t;
  print_string "\n"

(* print results *)
let print_result equal string_of_coalg string_of_alg vars terms values =
  let varnames = names vars in
  let varnamesf = assq equal (List.combine vars varnames) in
  let termnames = List.map (string_of_coalg varnamesf) terms in
  let valnames = List.map string_of_alg values in
  print_values varnames termnames;
  print_values varnames valnames;
  print_string "\n"