(* iterative fixpoint solver *)
module Solver =
  functor (C : Coalg.COALG) -> functor (A : Alg.ALG) -> struct
    type 'x equation = 'x * 'x C.term
      
    let equations (gamma : C.coalg -> C.coalg C.term) (c : C.coalg) : C.coalg equation list =
      let l = C.collect c in
      List.combine l (List.map gamma l)
          
    let iterate (equations : ('c * 'c C.term) list)
                (alpha : 'a C.term -> 'a) : ('c * 'a) list =
      let vars, eqs = List.split equations in
      let bot = List.map (fun _ -> A.init) vars in
      let rec iterate (env : 'a list) : 'a list =
        let c = List.combine vars env in
        let f = C.map (Util.assq C.equal c) in
        let inputs = List.map f eqs in
        let newenv = List.map alpha inputs in
        if (List.for_all2 A.equal env newenv) then env
        else iterate newenv in
      List.combine vars (iterate bot)
      
    (* driver *)
    let solve gamma alpha c =
      let eqs = equations gamma c in
      let vars, terms = List.split eqs in
      let solution = iterate eqs alpha in
      let _, values = List.split solution in
      Util.print_result C.equal C.string_of_term A.string_of_alg vars terms values
end