(* driver for probability example *)

module FC = Probcoalg
module FA = Probalg
module FD = Probdef
module S = Solver.Solver (FC) (FA)
let solve = List.iter (S.solve FD.gamma FD.alpha)

(* simulating a 1/3,2/3 coin with a fair coin *)
let rec t1 = FC.Flip (0.5, FC.H, FC.Flip (0.5, FC.T, t1))
(* von Neumann trick *)
let rec t2 = FC.Flip (0.345, FC.Flip (0.345, t2, FC.H), FC.Flip (0.345, FC.T, t2))
  
let _ = solve [t1; t2]