open Probcoalg
open Probalg

(* recursive equations definitions *)  
let rec alpha (t : alg term) : alg =
  match t with
    | H -> 1.
    | T -> 0.
    | Flip (p, t1, t2) -> p *. (alpha t1) +. (1. -. p) *. (alpha t2)
    | Ind x -> x

let rec gamma (t : coalg) : coalg term =
  match t with
    | H -> H
    | T -> T
    | Flip (p, t1, t2) -> Flip (p, Ind t1, Ind t2)
    | Ind _ -> failwith "Indeterminates not allowed"