(* driver for free variables example *)

module FC = Fvcoalg
module FA = Fvalg
module FD = Fvdef
module S = Solver.Solver (FC) (FA)
let solve = List.iter (S.solve FD.gamma FD.alpha)

let rec t1 = FC.App (FC.Var ("x"), t1)
let rec t2 = FC.App (FC.Var ("x"), FC.App (FC.Var ("x"), t2))
let rec t3 = FC.App (FC.Var ("z"), t1)
let rec t4 = FC.App (FC.Var ("x"), FC.App (FC.Var ("y"), t4))
let rec t5 = FC.App (FC.Var ("x"), FC.App (FC.Var ("y"), t3))
let rec t6 = FC.App (FC.Var ("x"), FC.App (t5, FC.App (FC.Var ("w"), t6)))
let rec t7 = FC.App (FC.App (FC.App (t7,FC.Var ("x")),FC.App (FC.Var ("y"),t7)),FC.Var ("z"))
let rec t8 = FC.Lam ("x", FC.App (FC.Var ("x"),FC.Var ("y")))
let rec t9 = FC.Lam ("x", FC.App (FC.Var ("x"),FC.App (FC.Var ("y"), t9)))

let _ = solve [t1; t2; t3; t4; t5; t6; t7; t8; t9]