open Fvcoalg
open Fvalg
  
(* Another specification in which gamma is not the identity *)
let rec alpha (t : alg term) : alg =
  match t with
    | App (App (t1, t2), t3) -> VarSet.union (VarSet.union (alpha t1) (alpha t2)) (alpha t3)
    | App (Var x, t1) -> VarSet.union (VarSet.singleton x) (alpha t1)
    | App (Lam (x, t1), t2) -> VarSet.union (VarSet.remove x (alpha t1)) (alpha t2)
    | App (Ind x, t1) -> VarSet.union x (alpha t1)
    | Lam (x, t1) -> VarSet.remove x (alpha t1)
    | Var x -> VarSet.singleton x
    | Ind x -> x

let rec gamma (t : coalg) : coalg term =
  match t with
    | App (App (t1, t2), t3) -> App (App (Ind t1, Ind t2), Ind t3)
    | App (Var x as t1, t2) -> App (Ind t1, Ind t2)
    | App (Lam (x, t1), t2) -> App (Lam (x, Ind t1), Ind t2)
    | App (Ind _, _) -> failwith "Indeterminates not allowed"
    | Var x -> Var x
    | Lam (x, t1) -> Lam (x, Ind t1)
    | Ind _ -> failwith "Indeterminates not allowed"