open Fvcoalg
open Fvalg

(* recursive equations definitions *)  
let rec alpha (t : alg term) : alg =
  match t with
    | Var x -> VarSet.singleton x
    | App (t1, t2) -> VarSet.union (alpha t1) (alpha t2)
    | Lam (x, t1) -> VarSet.remove x (alpha t1)
    | Ind x -> x

let rec gamma (t : coalg) : coalg term =
  match t with
    | Var x -> Var x
    | App (t1, t2) -> App (Ind t1, Ind t2)
    | Lam (x, t1) -> Lam (x, Ind t1)
    | Ind _ -> failwith "Indeterminates not allowed"