(* algebra structure for free variables *)
open Fvcoalg

module VarSet = Set.Make (
  struct
    type t = string
    let compare = Pervasives.compare
  end)

type alg = VarSet.t
let init = VarSet.empty
let equal = VarSet.equal

(* utilities *)
let string_of_alg (a : alg) : string =
  Printf.sprintf "{%s}" (String.concat "," (VarSet.elements a))