(* coalgebra structure *)
module type COALG =
  sig
    type 'x term (* terms over indeterminates 'x *)
    type coalg
    val equal : coalg -> coalg -> bool
    val collect : coalg -> coalg list (* collect all elements of a finite coalgebra *)
    val map : ('x -> 'y) -> 'x term -> 'y term
    
    (* for debugging *)
    val string_of_term : ('x -> string) -> 'x term -> string
  end