(* driver for automata example *)

module FC = Autocoalg
module FA = Autoalg
module FD = Autodef
module S = Solver.Solver (FC) (FA)
let solve = List.iter (S.solve FD.gamma FD.alpha)

(* two automata accepting {a,b}* *)
let rec s = FC.State (true, s, s)
let rec t = FC.State (true, FC.State (true, s, t), FC.State (true, t, s))
let a1 = FC.Pair (s, t)
  
(* strings ending with b *)
let rec s = FC.State (false, s, t)
and t = FC.State (true, s, t)
let a2 = FC.Pair (s, t)
  
let _ = solve [a1; a2]