open Autocoalg
open Autoalg

(* recursive equations definitions *)  
let rec alpha (a : alg term) : alg =
  match a with
    | State (b,s,t) -> b && (alpha s) && (alpha t)
    | Ind x -> x

let rec gamma (t : coalg) : coalg term =
  match t with
    | Pair (State (b1,s1,t1), State (b2,s2,t2)) ->
        State (b1 = b2, Ind (Pair (s1,s2)), Ind (Pair (t1,t2)))
    | _ -> failwith "Indeterminates not allowed"