/*These definitions are required by the IPmulticast code. Some systems do not*/
/* have these definitions in their netinet/in.h file.*/

#ifndef IN_CLASSD_NET
#define IN_CLASSD_NET      0xf0000000      /* These ones aren't really */
#endif

#ifndef IN_CLASSD_NSHIFT
#define IN_CLASSD_NSHIFT        28              /* net and host fields, but */
#endif

#ifndef IN_CLASSD_HOST
#define IN_CLASSD_HOST          0x0fffffff      /* routing needn't know.    */
#endif

#ifndef INADDR_UNSPEC_GROUP
#define INADDR_UNSPEC_GROUP     (u_long)0xe0000000      /* 224.0.0.0   */
#endif

#ifndef INADDR_ALLHOSTS_GROUP
#define INADDR_ALLHOSTS_GROUP   (u_long)0xe0000001      /* 224.0.0.1   */
#endif

#ifndef INADDR_MAX_LOCAL_GROUP
#define INADDR_MAX_LOCAL_GROUP  (u_long)0xe00000ff      /* 224.0.0.255 */
#endif
 
/*
 * Options for use with [gs]etsockopt at the IP level.
 */

#ifndef IP_OPTIONS
#define IP_OPTIONS              1       /* set/get IP per-packet options   */
#endif

#ifndef IP_MULTICAST_IF

#define IP_MULTICAST_IF         2       /* set/get IP multicast interface  */
#define IP_MULTICAST_TTL        3       /* set/get IP multicast timetolive */
#define IP_MULTICAST_LOOP       4       /* set/get IP multicast loopback   */
#define IP_ADD_MEMBERSHIP       5       /* add  an IP group membership     */
#define IP_DROP_MEMBERSHIP      6       /* drop an IP group membership     */
#define IP_DEFAULT_MULTICAST_TTL   1    /* normally limit m'casts to 1 hop  */
#define IP_DEFAULT_MULTICAST_LOOP  1    /* normally hear sends if a member  */
#define IP_MAX_MEMBERSHIPS         20   /* per socket; must fit in one mbuf */
 
/*
 * Argument structure for IP_ADD_MEMBERSHIP and IP_DROP_MEMBERSHIP.
 */
struct ip_mreq {
   struct in_addr  imr_multiaddr;  /* IP multicast address of group */
   struct in_addr  imr_interface;  /* local IP address of interface */
};
#endif


