/*
 * unix/dpSock.c --
 *
 *  This file implements the few Unix-specific routines for the
 *  socket code.
 *
 * Copyright (c) 1995-1996 Cornell University.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

#include "generic/dpInt.h"
#include "generic/dpPort.h"


/*
 *--------------------------------------------------------------
 *
 * DppCloseSocket --
 *
 *	Close the socket passed in.
 *
 * Results:
 *	None
 *
 * Side effects:
 *	None
 *
 *--------------------------------------------------------------
 */
int
DppCloseSocket (sock)
    DpSocket sock;
{
    return close(sock);
}


/*
 *--------------------------------------------------------------
 *
 * DppSetBlock --
 *
 *	Put the socket into a blocking or non-blocking state.
 *
 * Results:
 *	None
 *
 * Side effects:
 *	None
 *
 *--------------------------------------------------------------
 */
int
DppSetBlock (sock, block)
    DpSocket sock;
    int block;
{
    int flags;
    flags = fcntl(sock, F_GETFL, 0);
    if (block) {
	/* Set blocking mode */
	fcntl(sock, F_SETFL, flags & ~NBIO_FLAG);
    } else {
	/* Set non-blocking mode */
	fcntl(sock, F_SETFL, flags | NBIO_FLAG);
    }
    return 0;
}

/*
 * -------------------------------------------------------------
 *
 * DppGetErrno --
 *
 *	Returns the POSIX error code.
 *
 * Results:
 *	The POSIX errorcode.
 *
 * Side Effects:
 *	None.
 *
 * -------------------------------------------------------------
 */

int
DppGetErrno()
{
    return Tcl_GetErrno();
}    


