#ifndef _VIEW_H
#define _VIEW_H

#include "sockaddr.h"
#include "times.h"

/*
 * nlocal: #members in my local region (including myself).
 * nremote: #members in my parent region.
 * max_local_try: how many local requests should I send before concluding that the msg loss is regional?
 */
 
UL nlocal, nremote, max_local_try ;

bool am_sender, sender_region, found_sender ;
SAin sender ;
char sender_name[1024] ;

void view_init(void) ;

void view_print(void) ;

void view_print_full(void) ;

void view_incr_local(void) ;

void view_incr_remote(void) ;

void view_check_local(void) ;

void view_check_remote(void) ;

bool local_member(SAin) ;

void update_local_view(char *, SAin) ;

void update_remote_view(char *, SAin) ;

char *choose_local(SAin *, double *) ;

char *choose_remote(SAin *, double *) ;

char *choose_any(SAin *, double *) ;

void set_local_rtt(char *, double) ;

void set_remote_rtt(char *, double) ;

double get_max_rtt(void) ;

bool get_sender_rtt(double *) ;

char *get_remote_name(SAin) ;

SAin get_remote_addr(char *) ;

bool get_remote_rtt(char *, double *) ;

void add_sender(char *, SAin) ;

#endif
