#ifndef _UTIL_H
#define _UTIL_H

#include "posix1.h"
#include "type.h"

void *Malloc(size_t) ;

void *Calloc(size_t, size_t) ;

int int_max(int, int) ;

/************************************************/

void failwith(char *) ;

bool streq(char *, char *) ;

int strarr_index(size_t, char **, char *) ;

bool strarr_member(size_t, char **, char *) ;

/************************************************/

bool *bool_array_create(size_t, bool) ;

int bool_array_sum(bool *, size_t) ;

void bool_array_clear(bool *, size_t) ;

void bool_array_print(bool *, size_t) ;

bool *bool_array_dup(bool *, size_t) ;

void bool_array_copy(bool *, bool *, size_t) ;

int *int_array_create(size_t, int) ;

void int_array_add(int *, int *, size_t) ;

double int_array_avg(int *, size_t) ;

void int_array_print(int *, size_t) ;

int **int_matrix_create(size_t, int) ;

void int_matrix_free(int **, size_t) ;

double *double_array_create(size_t, double) ;

void double_array_print(double *, size_t) ;

/************************************************/

bool check_file(char *) ;

bool check_stop(void) ;

char *bool_to_string(bool) ;

bool bool_of_string(char *) ;

bool isblkcmt(char []) ;

FILE *Fopen(char *, char *) ;

char *Fgets(char *, int, FILE *) ;

int int_min(int, int) ;

int readln(FILE *, char []) ;

double ratio(unsigned long, unsigned long) ;

bool seqno_array_find(Seqno *, size_t, Seqno) ;

void seqno_array_print(Seqno *, size_t) ;

void rand_init(void) ;

size_t rand_int(size_t) ;

size_t rand_int2(size_t, int) ;

float rand_frac(void) ;

#endif
