#include "util.h"


void failwith(char *errmsg) {
  printf("%s\n", errmsg) ;
  exit(1) ;
}


inline bool streq(char *s1, char *s2) {
  return(strcmp(s1, s2) == 0) ;
}


int strarr_index(size_t cnt, char **strs, char *target) {
  int i ;

  for (i = 0; i < cnt; i++) {
    if (streq(strs[i], target)) return(i) ;
  }
  return(-1) ;
}


bool strarr_member(size_t cnt, char **strs, char *target) {
  if (strarr_index(cnt, strs, target) < 0)
    return(false) ;
  return(true) ;
}


bool *bool_array_create(size_t cnt, bool value) {
  bool *p ;
  int i ;

  p = Calloc(cnt, sizeof(bool)) ;
  for (i = 0; i < cnt; i++){
    p[i] = value ;
  }
  return(p) ;
}


int bool_array_sum(bool *arr, size_t cnt) {
  int sum, i ;

  sum = 0 ;
  for (i=0; i<cnt; i++) {
    if (arr[i]) sum++ ;
  }
  return(sum) ;
}


void bool_array_clear(bool *arr, size_t cnt) {
  int i ;

  for (i=0; i<cnt; i++) {
    arr[i] = false ;
  }
  return ;
}


void bool_array_print(bool *arr, size_t cnt) {
  int i ;
  
  printf("[") ;
  for (i = 0; i < cnt; i++) {
    printf("%s ", bool_to_string(arr[i])) ;
  }
  printf("]\n") ;
}


void bool_array_print_true(bool *arr, size_t cnt) {
  int i ;

  printf("[") ;
  for (i=0; i<cnt; i++) {
    if (arr[i]) printf("%d ", i) ;
  }
  printf("]\n") ;
}


bool *bool_array_dup(bool *arr, size_t cnt) {
  bool *p ;
  int i ;
  
  p = Calloc(cnt, sizeof(bool)) ;
  for (i = 0; i < cnt; i++) {
    p[i] = arr[i] ;
  }
  return(p) ;
}


void bool_array_copy(bool *dst, bool *src, size_t cnt) {
  int i ;

  for (i=0; i<cnt; i++) {
    dst[i] = src[i] ;
  }
  return ;
}


int *int_array_create(size_t cnt, int value) {
  int *p ;
  int i ;

  p = Calloc(cnt, sizeof(int)) ;
  for (i = 0; i < cnt; i++) {
    p[i] = value ;
  }
  return(p) ;
}


void int_array_add(int *arr1, int *arr2, size_t cnt) {
  int i ;

  for (i=0; i<cnt; i++) {
    arr1[i] += arr2[i] ;
  }
  return ;
}


double int_array_avg(int *intarr, size_t cnt) {
  double total ;
  int i ;

  total = 0.0 ;
  for (i=0; i<cnt; i++) {
    total += intarr[i] ;
  }
  return (total / cnt) ;
}


void int_array_print(int *intarr, size_t cnt) {
  int i ;

  printf("[") ;
  for (i = 0; i < cnt; i++) {
    printf("%d ", intarr[i]) ;
  }
  printf("]\n") ;
}


int **int_matrix_create(size_t cnt, int value) {
  int **p ;
  int i ;

  p = Calloc(cnt, sizeof(int *)) ;
  for (i = 0; i < cnt; i++) {
    p[i] = int_array_create(cnt, value) ;
  }
  return(p) ;
}


void int_matrix_free(int **p, size_t cnt) {
  int i ;

  for (i = 0; i < cnt; i++) {
    free(p[i]) ;
  }
  free(p) ;
  return ;
}


double *double_array_create(size_t cnt, double value) {
  double *p ;
  int i ;

  p = Calloc(cnt, sizeof(double)) ;
  for (i=0; i<cnt; i++) {
    p[i] = value ;
  }
  return(p) ;
}


void double_array_print(double *arr, size_t cnt) {
  int i ;

  printf("[") ;
  for (i=0; i<cnt; i++) {
    printf("%.3f ", arr[i]) ;
  }
  printf("]\n") ;
}


bool check_file(char *fname) {
  FILE *fp ;

  fp = fopen(fname, "r") ;
  return(fp != NULL) ;
}


bool check_stop(void) {
  char *root ;
  char fname[256] ;

  root = getenv("RRMP") ;
  if (root == NULL) {
    printf("Please set environment variable RRMP to the root directory of your RRMP software.\n") ;
    printf("For example, setenv RRMP /home/xiao/release\n") ;
    exit(1) ;
  }
  strcpy(fname, root) ;
  strcat(fname, "/stop") ;
  return(check_file(fname)) ;
}


char *bool_to_string(bool b) {
  if (b) 
    return "true" ;
  else 
    return "false" ;
}


bool bool_of_string(char *str) {
  if (streq(str, "true"))
    return(true) ;
  else if (streq(str, "false"))
    return(false) ;
  else {
    fprintf(stderr, "bool_of_string [%s]: invalid boolean value.\n", str) ; 
    exit(1) ;
  }
}


bool isblkcmt(char line[]) {
  int i ;

  if (line == NULL) {
    printf("Error: NULL line pointer.\n") ;
    exit (-1) ;
  }
  
  for (i = 0; i < strlen(line); i++) {
    if (line[i] == '#') 
      return true ;
    if (!isspace(line[i]))
      return false ;
  }
  return true ;
}


void *Malloc(size_t size) {
  char *p ;
  
  if ((p = (char *)malloc(size)) == NULL) {
    fprintf(stderr, "Malloc: cannot allocate memory\n") ;
    exit(-1) ;
  } ;
  return(p) ;
}


void *Calloc(size_t num, size_t size) {
  char *p ;
  
  if ((p = calloc(num, size)) == NULL) {
    fprintf(stderr, "Calloc: cannot allocate memory\n") ;
    exit(-1) ;
  }
  return(p) ;
}


FILE *Fopen(char *fname, char *mode) {
  FILE *fp ;

  if ((fp = fopen(fname, mode)) == NULL) {
    fprintf(stderr, "Fopen [%s]: No such file or directory\n", fname) ;
    exit(-1) ;
  }
  return(fp) ;
}


char *Fgets(char *line, int line_size, FILE *fp) {
  char *p ;
  int i ;

  errno = 0 ;
  if ((p = fgets(line, line_size, fp)) == NULL) {
    if (errno > 0) {
      perror("fgets") ;
      exit(-1) ;
    }
    return(p) ;
  }
  /* get rid of the ending "\n" */
  for (i = 0; i < line_size; i++) {
    if (line[i] == '\n') {
      line[i] = '\0' ;
      return(p) ;
    }
  }
}


/* BSD has no max function */
int int_max(int i, int j) {
  if (i >= j) return(i) ;
  else return(j) ;
}


int int_min(int i, int j) {
  if (i <= j) return(i) ;
  else return(j) ;
}


double ratio(unsigned long part, unsigned long total) {
  assert (part <= total) ;
  if (total == 0) return(0) ;
  return (part * 100.0 / total) ;
}



bool seqno_array_find(Seqno *arr, size_t size, Seqno seqno) {
  size_t i ;

  for (i=0; i<size; i++) {
    if (seqno == arr[i]) return(true) ;
  }
  return(false) ;
}


void seqno_array_print(Seqno *arr, size_t size) {
  size_t i ;

  for (i=0; i<size; i++) {
    printf("%lu ", arr[i]) ;
  }
  printf("\n") ;
  return ;
}


void rand_init(void) {
  TV t ;

  gettimeofday(&t, NULL) ;
  srandom(t.tv_usec) ;
  return ;
}


void rand_seed(long seed) {
  srandom(seed) ;
}


size_t rand_int(size_t range) {
  assert (range > 0) ;
  /*  return(rand() % range) ;*/
  return(random() % range) ;
}


size_t rand_int2(size_t range, int me) {
  int i ;

  while (1) {
    i = rand_int(range) ;
    if (i != me) return(i) ;
  }
}


float rand_frac(void) {
  int i ;
  float f ;

  i = rand_int(10000) ;
  f = (float) i ;
  return(f / 10000.0) ;
}

