#include "times.h"


TV Gettimeofday(void) {
  TV t ;

  if (gettimeofday(&t, NULL) < 0) {
    fprintf(stderr, "gettimeofday error\n") ;
    exit(2) ;
  }
  return(t) ;
}


TV time_invalid(void) {
  TV t ;

  t.tv_sec = -1 ;
  t.tv_usec = -1 ;
  return(t) ;
}


bool time_is_invalid(TV t) {
  return(t.tv_sec == -1 && t.tv_usec == -1) ;
}


TV time_of_zero(void) {
  TV t ;

  t.tv_sec = 0 ;
  t.tv_usec = 0 ;
  return(t) ;
}


bool time_is_zero(TV t) {
  return(t.tv_sec == 0 && t.tv_usec == 0) ;
}


TV time_of_double(double f) {
  TV t ;

  t.tv_sec = floor(f) ;
  f = f - t.tv_sec ;
  t.tv_usec = floor(f * 1.0E6) ;
  return t ;
}


double time_to_double(TV t) {
  double f = t.tv_sec + (t.tv_usec / 1.0E6) ;
  return f ;
}


TV of_longs(long sec, long usec) {
  TV t ;

  if (usec < 0) {
    return(of_longs(sec - 1, usec + million)) ;
  }
  if (usec >= million) {
    t.tv_sec = sec + usec / million ;
    t.tv_usec = usec % million ;
    assert(t.tv_usec >= 0 && t.tv_usec < million) ;
    return(t) ;
  }
  t.tv_sec = sec ;
  t.tv_usec = usec ;
  return(t) ;
}


double get_time(void) {
  return(time_diff(Gettimeofday(), start_time)) ;
}


double time_diff(TV t1, TV t2) {
  double f1 = time_to_double(t1) ;
  double f2 = time_to_double(t2) ;
  return(fabs(f2 - f1)) ;
}


TV time_add(TV t1, TV t2) {
  long sec = t1.tv_sec + t2.tv_sec ;
  long usec = t1.tv_usec + t2.tv_usec ;
  return(of_longs(sec, usec)) ;
  /*
    double f1 = time_to_double(t1) ;
    double f2 = time_to_double(t2) ;
    return(time_of_double(f1 + f2)) ;
    */
}


bool time_gt(TV t1, TV t2) {
  if (t1.tv_sec == t2.tv_sec) {
    return(t1.tv_usec > t2.tv_usec) ;
  }
  return(t1.tv_sec > t2.tv_sec) ;
}


bool time_lt(TV t1, TV t2) {
  return(time_gt(t2, t1)) ;
}


bool time_ge(TV t1, TV t2) {
  if (t1.tv_sec == t2.tv_sec) {
    return(t1.tv_usec >= t2.tv_usec) ;
  }
  return(t1.tv_sec > t2.tv_sec) ;
}


/* compute the absolute value */
TV time_sub(TV t1, TV t2) {
  long sec, usec ;

  if (time_ge(t1, t2)) {
    sec = t1.tv_sec - t2.tv_sec ;
    usec = t1.tv_usec - t2.tv_usec ;
    return(of_longs(sec, usec)) ;
  }
  sec = t2.tv_sec - t1.tv_sec ;
  usec = t2.tv_usec - t1.tv_usec ;
  return(of_longs(sec, usec)) ;
  /*
    double f1 = time_to_double(t1) ;
    double f2 = time_to_double(t2) ;
    double dur = fabs(f2 - f1) ;
    return(time_of_double(dur)) ;
    */
}


void time_print(char *prefix, TV t) {
  printf("%s: %lu sec %lu usec\n", prefix, t.tv_sec, t.tv_usec) ;
}


TV time_set(double testtime) {
  TV dur, end ;
  
  if (testtime > 0) {
    dur = time_of_double(testtime) ;
    end = Gettimeofday() ;
    end = time_add(end, dur) ;
  } else {
    end = time_invalid() ;
  }
  return(end) ;
}


bool time_expire(TV now, TV end) {
  return(!time_is_invalid(end) && time_ge(now, end)) ;
}


#define RANGE 0.30

TV time_perturb(TV t) {
  double f, frac, delta ;

  f = time_to_double(t) ;
  frac = rand_frac() ;
  delta = f * RANGE * 2 * frac ;
  f = f - RANGE + delta ;
  return(time_of_double(f)) ;
}
