#include "strlst.h"

typedef struct strlst_node Node ;

StrLst strlst_init(void) {
  StrLst l ;

  l.head = l.tail = NULL ;
  l.length = 0 ;
  return(l) ;
}


Node *strlst_create (char *str) {
  Node *p ;

  p = (Node *)Malloc(sizeof(Node)) ;
  p->str = strdup(str) ;
  p->next = NULL ;
  return(p) ;
}


void strlst_append(StrLst *l, char *str) {
  Node *p ;

  p = strlst_create(str) ;
  if (l->tail == NULL) {
    l->head = l->tail = p ;
  } else {
    l->tail->next = p ;
    l->tail = p ;
  }
  l->length++ ;
}


char *strlst_pop(StrLst *l) {
  char *str ;

  if (l->head == NULL) return(NULL) ;
  str = l->head->str ;
  if (l->tail == l->head) {
    l->tail = l->head = l->head->next ;
  } else {
    l->head = l->head->next ;
  }
  l->length-- ;
  return(str) ;
}


void strlst_print(StrLst l) {
  Node *p ;

  printf("length: %d\n", l.length) ;
  p = l.head ;
  while (p != NULL) {
    printf("[%s]\n", p->str) ;
    p = p->next ;
  }
}


/* The list is freed after converted into an array */
char **strlst2array(StrLst l, int *len) {
  char **ary ;
  Node *p ;
  int i ;

  ary = Calloc(l.length, sizeof(char *)) ;
  p = l.head ;
  for (i = 0; i < l.length; i++) {
    l.head = l.head->next ;
    assert(p != NULL) ;
    ary[i] = p->str ;
    free(p) ;
    p = l.head ;
  }
  *len = l.length ;
  return(ary) ;
}


StrLst file2strlst(char *fname) {
  FILE *fp ;
  StrLst l ;
  char line[LINESIZE] ;

  fp = Fopen(fname, "r") ;
  l = strlst_init() ;
  while (Fgets(line, LINESIZE, fp) != NULL) {
    if (!isblkcmt(line)) {
      strlst_append(&l, line) ;
    }
  }
  fclose(fp) ;
  return(l) ;
}

