#include "sockaddr.h"

SAin Getsockname(int sock) {
  SAin addr ;
  size_t len ;

  len = sizeof(addr);
  if (getsockname(sock, (SA *)&addr, &len)) {
    perror("getting socket name");
    exit(1);
  }
  return(addr) ;
}


int get_sock_port(int sock) {
  SAin addr ;

  addr = Getsockname(sock) ;
  return(ntohs(addr.sin_port)) ;
}


bool addr_eq(SAin addr1, SAin addr2) {
  return(addr1.sin_port == addr2.sin_port
  && addr1.sin_addr.s_addr == addr2.sin_addr.s_addr) ;
}


bool addr_ip_eq(SAin addr1, SAin addr2) {
  return(addr1.sin_addr.s_addr == addr2.sin_addr.s_addr) ;
}


SAin getaddrbyname(char *name, int port) {
  HT *host ;
  SAin addr ;

  host = Gethostbyname(name) ;
  bzero((char *) &addr, sizeof(addr)) ;
  addr.sin_family = AF_INET ;
  bcopy(host->h_addr, (char *) &addr.sin_addr, host->h_length);
  addr.sin_port = htons(port) ;
  return(addr) ;
}


SAin getmyaddr(int port) {
  SAin addr ;
  char myname[MAXHNAMELEN+1];

  Gethostname(myname, MAXHNAMELEN) ;
  addr = getaddrbyname(myname, port) ;
  return(addr) ;
}


SAin getaddrbyip(char *ipstr, int port) {
  SAin addr ;

  bzero(&addr, sizeof(SAin)) ;
  addr.sin_family = AF_INET ;
  addr.sin_port = htons(port) ;
  if ((addr.sin_addr.s_addr = inet_addr(ipstr)) == -1) {
    fprintf(stderr, "Invalid IP address.\n") ;
    exit(-1) ;
  } ;
  return(addr) ;
}


SAin str2addr(char *str, int port) {
  if (inet_addr(str) == -1) {
    return(getaddrbyname(str, port)) ;
  } else {
    return(getaddrbyip(str, port)) ;
  }
}


void host_print_ip(HT *host) {
  unsigned char *p ;
  p = (unsigned char *)host->h_addr_list[0] ;
  printf("%d.%d.%d.%d\n", p[0], p[1], p[2], p[3]) ;
}


void addr_print(char *prefix, SAin addr) {
  printf("%s:  %s %d\n", prefix, inet_ntoa(addr.sin_addr), addr.sin_port) ;
}


SAin *addrarr_dup(int cnt, SAin *addr) {
  SAin *p ;
  int i ;

  p = Calloc(cnt, sizeof(SAin)) ;
  for (i = 0; i < cnt; i++) {
    p[i] = addr[i] ;
  }
  return(p) ;
}


bool addrarr_member(SAin addr, int cnt, SAin *addrarr) {
  int i ;

  for (i = 0; i < cnt; i++) {
    if (addr_eq(addr, addrarr[i]))
      return(true) ;
  }
  return(false) ;
}


bool addr_gt(SAin addr1, SAin addr2) {
  return(addr1.sin_addr.s_addr > addr2.sin_addr.s_addr) ;
}
