#include "rate.h"
#include "appl_intf.h"
#include <unistd.h>

#define MAXMSGSIZE 20480

static struct state {
  bool first, ready ;
  int often, nmembers, msg_size ;
  Seqno seqno ;
  TV end, t, next ;
  long total ;
  Rate r ;
  double sweep ;
} s ;


static void recv_hbt(void) {
  char buf[MAXMSGSIZE] ;
  TV now ;

  if (s.first) {
    s.first = false ;
    s.r = rate_init(s.often, "-sender") ;
  }
  
  now = Gettimeofday() ;
  if (time_expire(now, s.end) || s.seqno > s.total) {
    appl_stop() ;
  }
  
  while (time_ge(now, s.next)) {
    bzero(buf, 10) ;
    sprintf(buf, "%lu", s.seqno) ;
    appl_cast(buf, s.msg_size) ;
    s.seqno++ ;
    rate_gotmsg(&s.r) ;
    s.next = time_add(s.next, s.t) ;
  }
  return ;
}


static void recv_view(size_t nmembers) {
  double testtime ;

  /* wait until we have the correct group size */
  if (nmembers == s.nmembers) {
    appl_recv_hbt = recv_hbt ;
    appl_hbt_rate = s.sweep ;
    s.ready = true ;
    s.seqno = 0 ;
    testtime = param_double("testtime") ;
    s.end = time_set(testtime) ;
    s.total = param_int("total") ;
    s.next = Gettimeofday() ;  /* has to set it here */
    appl_start_hbt() ;
  } else if (nmembers > s.nmembers) {
    failwith("Error: got more members than expected") ;
  } else if (s.ready) {
    /*
    printf("lost some members\n") ;
    appl_stop() ;
    */
  }
  return ;
}


void main (int argc, char **argv) {
  double msg_rate ;

  appl_init(argc, argv) ;
  if (argc < 2) {
    fprintf(stderr, "Usage: %s <msg_size>\n", argv[0]) ;
    exit(1) ;
  }

  s.msg_size = atoi (argv[1]);
  if (s.msg_size < 10) {
    s.msg_size = 10 ;
    fprintf(stderr, "Warning: msg too small for seqno number. Expanded to 10 bytes.\n") ;
  } else if (s.msg_size >= MAXMSGSIZE) {
    fprintf(stderr, "Error: msg size too large.\n") ;
    exit(1) ;
  }

  msg_rate = param_double("msg_rate") ;
  s.often = ceil(msg_rate) ;
  printf ("sending %d-bytes message at %.2f messages per second\n", s.msg_size, msg_rate);

  s.sweep = 1.0 / msg_rate ;
  s.t = time_of_double(s.sweep) ;
  time_print("t", s.t) ;

  s.first = true ;
  s.ready = false ;
  s.nmembers = param_int("nmembers") ;
  printf("need %u members to start ..\n", s.nmembers) ;

  appl_recv_view = recv_view ;
  appl_main_loop() ;
}
