#include "rate.h"

Rate rate_init(unsigned often, char *suffix) {
  Rate r ;

  r.often = often ;
  r.suffix = strdup(suffix) ;
  r.nmsgs = 0 ;
  r.prev = Gettimeofday() ;
  r.now = time_invalid() ;
  return(r) ;
}


double rate_gotmsg(Rate *r) {
  double recv_rate, dur ;

  r->nmsgs++ ;
  assert(r->often > 0) ;
  if (r->nmsgs % r->often == 0) {
    r->now = Gettimeofday() ;
    dur = time_diff(r->prev, r->now) ;
    assert(dur > 0) ;
    recv_rate = r->often / dur ;
    r->prev = r->now ;
    printf ("#msgs = %d  recv_rate = %6.2f %s\n", r->nmsgs, recv_rate, r->suffix) ;
  }
  return(recv_rate) ;
}


void rate_print(Rate r) {
  printf("often: %u   nmsgs: %u\n", r.often, r.nmsgs) ;
  time_print("prev", r.prev) ;
  time_print("now", r.now) ;
}
