#include "timer.h"
#include "type.h"

struct node {
  Type type ;
  Seqno seqno ;
  timer_id id ;
  struct node *next ;
} ;


typedef struct node Node ;

static Node *head = NULL ;

void pending_print(void) {
  Node *p ;

  printf("Pending timers:\n") ;
  printf("  type seqno timer_id\n") ;
  p = head ;
  while (p != NULL) {
    printf("   %d    %lu     %lu\n", p->type, p->seqno, p->id) ;
    p = p->next ;
  }
  printf("End\n") ;
  return ;
}


void pending_set(Type type, Seqno seqno, timer_id id) {
  Node *p ;

  p = head ;
  while (p != NULL) {
    if (p->type == type && p->seqno == seqno) {
      p->id = id ;
      return ;
    }
    p = p->next ;
  }
  p = Malloc(sizeof(Node)) ;
  p->type = type ;
  p->seqno = seqno ;
  p->id = id ;
  p->next = head ;
  head = p ;
  return ;
}


timer_id pending_del(Type type, Seqno seqno) {
  Node *p, *pre ;
  timer_id id ;

  p = head ;
  pre = NULL ;
  while (p != NULL) {
    if (p->type == type && p->seqno == seqno) {
      id = p->id ;
      if (pre != NULL) {
	pre->next = p->next ;
      } else {
	head = p->next ;
      }
      free(p) ;
      return(id) ;
    }
    pre = p ;
    p = p->next ;
  }
  printf("Error[pending]: entry not found\n") ;
  exit(1) ;
}


void pending_cancel(Type type, Seqno seqno) {
  timer_id id ;

  id = pending_del(type, seqno) ;
  timer_cancel(id) ;
  return ;
}


bool pending_exist(Type type, Seqno seqno) {
  Node *p ;

  p = head ;
  while (p != NULL) {
    if (p->type == type && p->seqno == seqno) {
      return(true) ;
    }
    p = p->next ;
  }
  return(false) ;
}
