#include "param.h"
#include "net.h"

struct node {
  char *name ;
  char *value ;
  struct node *next ;
} ;

typedef struct node Node ;

struct lst {
  Node *head, *tail ;
} param ;


Node *param_create(char *name, char *value) {
  Node *p ;

  p = Malloc(sizeof(Node)) ;
  p->name = strdup(name) ;
  p->value = strdup(value) ;
  p->next = NULL ;
  return(p) ;
}


void param_append(char *name, char *value) {
  Node *p ;

  p = param_create(name, value) ;
  if (param.tail == NULL) {
    param.head = param.tail = p ;
  } else {
    param.tail->next = p ;
    param.tail = p ;
  }
  return ;
}


void param_print(void) {
  Node *p ;

  printf("Param list:\n") ;
  p = param.head ;
  while (p != NULL) {
    printf("  [%s]=[%s]\n", p->name, p->value) ;
    p = p->next ;
  }
  return ;
}


char *param_find(char *name) {
  Node *p ;

  p = param.head ;
  while (p != NULL) {
    if (streq(p->name, name)) {
      return(p->value) ;
    }
    p = p->next ;
  }
  printf("Param Error: [%s] not found\n", name) ;
  exit(1) ;
}


bool param_exist(char *name) {
  Node *p ;

  p = param.head ;
  while (p != NULL) {
    if (streq(p->name, name)) {
      return(true) ;
    }
    p = p->next ;
  }
  return(false) ;
}


int param_int(char *name) {
  char *str ;

  str = param_find(name) ;
  return(atoi(str)) ;
}


int param_int2(char *name, int dft) {
  if (param_exist(name)) {
    return(param_int(name)) ;
  }
  return(dft) ;
}


double param_double(char *name) {
  char *str ;

  str = param_find(name) ;
  return(atof(str)) ;
}


bool param_bool(char *name) {
  char *str ;

  str = param_find(name) ;
  return(bool_of_string(str)) ;
}


bool param_bool2(char *name, bool dft) {
  if (param_exist(name)) {
    return(param_bool(name)) ;
  }
  return(dft) ;
}


char *param_str(char *name) {
  char *str ;

  str = param_find(name) ;
  return(str) ;
}


TV param_time(char *name) {
  double d ;

  d = param_double(name) ;
  return(time_of_double(d)) ;
}


void param_file(void) {
  char *root ;
  char fname[256] ;
  FILE *fp ;
  char line[LINESIZE] ;
  char *name, *value ;

  root = getenv("RRMP") ;
  if (root == NULL) {
    printf("Please set environment variable RRMP to the root directory of your RRMP software.\n") ;
    printf("For example, setenv RRMP /home/xiao/release\n") ;
    exit(1) ;
  }

  strcpy(fname, root) ;
  strcat(fname, "/args") ;

  if ((fp = fopen(fname, "r")) == NULL) {
    return ;
  }

  while (Fgets(line, LINESIZE, fp) != NULL) {
    if (!isblkcmt(line)) {
      if ((name = strtok(line, "=")) == NULL
      || (value = strtok(NULL, "\n")) == NULL) {
	fprintf(stderr, "Format error: %s\n", line) ;
	exit(-1) ;
      }
      param_append(name, value) ;
    }
  }
  fclose(fp) ;
  return ;
}


void param_cmdline(int argc, char **argv) {
  char *name, *value ;
  int i ;

  for (i = 1; i < argc; i++) {
    if ((name = strtok(argv[i], "=")) != NULL
    && (value = strtok(NULL, "\n")) != NULL) {
      param_append(name, value) ;
    }
  }
  return ;
}


void param_init2(int argc, char **argv) {
  param.head = param.tail = NULL ;
  param_cmdline(argc, argv) ;
  return ;
}


void param_init(int argc, char **argv) {
  param.head = param.tail = NULL ;

  param_cmdline(argc, argv) ;

  param_file() ;

  param_append("pt2pt_port", PT2PT_PORT) ;
  param_append("cast_port", CAST_PORT) ;
  param_append("ipaddr", IPADDR) ;

  param_append("msg_rate", "100") ;
  /* by default demos run half an hour, send 200k msgs */
  param_append("testtime", "1800") ;
  param_append("total", "200000") ;
  param_append("unique", "false") ;
  param_append("nmembers", "2") ;
  param_append("max_burst", "2") ;
  param_append("sender_dbg", "false") ;
  param_append("loss_hbt_rate", "1.0") ;
  param_append("nrounds", "100") ;  /* rtt */

  param_append("param_dbg", "false") ;
  param_append("ev_dbg", "false") ;
  param_append("stack_dbg", "false") ;
  param_append("iq_dbg", "false") ;
  param_append("latency_dbg", "false") ;

  param_append("uniread", "false") ;
  param_append("omit_view", "false") ;
  param_append("full_view", "false") ;

  if (param_bool("param_dbg")) param_print() ;
  return ;
}
