#include "net.h"
#include <unistd.h>

Sock socket_dgram(void) {
  Sock sock ;

  if ((sock = socket (AF_INET, SOCK_DGRAM, 0)) == -1) {
    printf ("Error creating socket.\n");
    exit (-1);
  }
  /*  set_reuse(sock) ;*/
  return sock ;
}


Sock socket_stream(void) {
  Sock sock ;

  if ((sock = socket (AF_INET, SOCK_STREAM, 0)) == -1) {
    printf ("Error creating socket.\n");
    exit (-1);
  }
  return sock ;
}


void Bind(Sock sock, SAin *addr) {
  if (bind(sock, (SA *)addr, sizeof(SAin)) == -1) {
    fprintf (stderr, "Error binding socket[#%d]: %s.\n", errno, strerror(errno));
    exit (-1);
  }
}


HT *Gethostbyname(char *name) {
  HT *host ;

  if ((host = gethostbyname(name)) == NULL) {
    perror("gethostbyname") ;
    exit (-1);
  }
  return(host) ;
}


void Gethostname(char *name, int namelen) {
  if (gethostname(name, namelen) == -1) {
    printf ("Error: gethostname\n");
    exit (-1);
  }
}


void Gethostname2(char *name, int namelen) {
  char *p ;

  Gethostname(name, namelen) ;
  if ((p = strchr(name, '.')) != NULL) {
    *p = '\0' ;
  }
  return ;
}


int Sendto(Sock sock, void *msg, size_t msg_size, SAin *toaddr) {
  int n ;

  if ((n = sendto(sock, msg, msg_size, 0, (SA *)toaddr, sizeof(SAin))) < 0) {
    if (errno == ECONNREFUSED) {
      /* Working around a Linux problem */
      n = sendto(sock, msg, msg_size, 0, (SA *)toaddr, sizeof(SAin)) ;
      return(n) ;
    }
    fprintf(stderr, "Error sending datagram[#%d]: %s.\n", errno, strerror(errno)) ;
    exit(-1) ;
  }
  return(n) ;
}


int Sendmsg(Sock sock, void *msg1, size_t len1, void *msg2, size_t len2, SAin *toaddr) {
  struct msghdr m ;
  struct iovec iov[2] ;
  int n ;

  /* Must zero out before use */
  bzero(&m, sizeof(struct msghdr)) ;
  iov[0].iov_base = msg1 ;
  iov[0].iov_len = len1 ;
  iov[1].iov_base = msg2 ;
  iov[1].iov_len = len2 ;
  m.msg_name = (void *)toaddr ;
  m.msg_namelen = sizeof(SAin) ;
  m.msg_iov = iov ;
  m.msg_iovlen = 2 ;

  if ((n = sendmsg(sock, &m, 0)) < 0) {
    if (errno == ECONNREFUSED) {
      /* Working around a Linux problem */
      n = sendmsg(sock, &m, 0) ;
      return(n) ;
    }
    fprintf(stderr, "Error sending msg[#%d]: %s.\n", errno, strerror(errno)) ;
    exit(-1) ;
  }

  return(n) ;
}

#if 0
int Sendmsg2(Sock sock, void *msg1, size_t len1, void *msg2, size_t len2, void *msg3, size_t len3, SAin *toaddr) {
  struct msghdr m ;
  struct iovec iov[3] ;
  int n ;

  /* Must zero out before use */
  bzero(&m, sizeof(struct msghdr)) ;
  iov[0].iov_base = msg1 ;
  iov[0].iov_len = len1 ;
  iov[1].iov_base = msg2 ;
  iov[1].iov_len = len2 ;
  iov[2].iov_base = msg3 ;
  iov[2].iov_len = len3 ;
  m.msg_name = (void *)toaddr ;
  m.msg_namelen = sizeof(SAin) ;
  m.msg_iov = iov ;
  m.msg_iovlen = 3 ;

  if ((n = sendmsg(sock, &m, 0)) < 0) {
    if (errno == ECONNREFUSED) {
      /* Working around a Linux problem */
      n = sendmsg(sock, &m, 0) ;
      return(n) ;
    }
    fprintf(stderr, "Error sending msg[#%d]: %s.\n", errno, strerror(errno)) ;
    exit(-1) ;
  }

  return(n) ;
}
#endif


int Write(Sock sock, char *msg, size_t msg_size) {
  size_t nleft, nwritten ;
  char *ptr ;

  nleft = msg_size ;
  ptr = msg ;
  while (nleft > 0) {
    if ((nwritten = write(sock, ptr, nleft)) <= 0) {
      perror("writing on stream socket") ;
      exit(-1) ;
    }
    nleft -= nwritten ;
    ptr += nwritten ;
  }
  return(msg_size-nleft) ;
}


size_t Recvfrom(Sock sock, void *buf, size_t length, SAin *fromaddr, size_t *addrlen) {
  int n ;

  if ((n = recvfrom(sock, buf, length, 0, (SA *)fromaddr, addrlen)) < 0) {
    fprintf(stderr, "Error recving datagram[#%d]: %s.\n", errno, strerror(errno)) ;
    exit(-1) ;
  } ;
  if (n == length) {
    fprintf(stderr, "Error recving datagram: Message too long!\n") ;
    exit(-1) ;
  }

  return(n) ;
}

  /*
  size_t nleft ;
  char *ptr ;
  size_t nread ;

  nleft = msg_size ;
  ptr = msg ;
  while (nleft > 0) {
    if ((nread = recvfrom (sock, ptr, nleft, 0, fromaddr, addrlen)) < 0) {
      fprintf(stderr, "Error reading socket.\n") ;
      exit(-1) ;
    } ;
    nleft -= nread ;
    ptr += nread ;
  }
  */


int socket_dgram_and_bind(int port) {
  Sock sock ;
  SAin addr ;

  sock = socket_dgram() ;
  bzero(&addr, sizeof(SAin)) ;
  addr.sin_family = AF_INET ;
  addr.sin_addr.s_addr = htonl(INADDR_ANY) ;
  addr.sin_port = htons(port) ;
  Bind(sock, &addr) ;
  return(sock) ;
}


int socket_stream_and_bind(int port) {
  Sock sock ;
  SAin addr ;

  sock = socket_stream() ;
  bzero(&addr, sizeof(SAin)) ;
  addr.sin_family = AF_INET ;
  addr.sin_addr.s_addr = htonl(INADDR_ANY) ;
  addr.sin_port = htons(port) ;
  Bind(sock, &addr) ;
  return(sock) ;
}


int Accept(Sock sock) {
  Sock msgsock ;

  msgsock = accept(sock, 0, 0) ;
  if (msgsock == -1) {
    perror("accept") ;
  }
  return(msgsock) ;
}

/*
void set_reuse(int sock) {
  char flag ;

  flag = 1 ;
  if (setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, &flag, sizeof(char)) == -1) {
    fprintf(stderr, "Error setting socket reuse[#%d]: %s.\n", errno, strerror(errno)) ;
    exit(1) ;
  }
}
*/

void set_ttl(Sock sock, char *ttl) {
  if (setsockopt (sock, IPPROTO_IP, IP_MULTICAST_TTL, ttl, sizeof(char)) == -1) {
    printf ("Error setting MULTICAST_TTL.\n") ;
    exit (1) ;
  }
}


void join_group(Sock sock, SAin grpaddr) {
  struct ip_mreq mreq ;

  mreq.imr_interface.s_addr = INADDR_ANY ;
  memcpy (&mreq.imr_multiaddr, &(grpaddr.sin_addr), sizeof (struct in_addr)) ;
    
  if (setsockopt (sock, IPPROTO_IP, IP_ADD_MEMBERSHIP, (void *)&mreq, sizeof (mreq)) == -1) {
    fprintf (stderr, "Error joining multicast group[#%d]: %s.\n", errno, strerror(errno)) ;
    exit (-1) ;
  }
}


void Connect(Sock sock, SAin addr) {
  if (connect(sock, (SA *)&addr, sizeof(addr)) < 0) {
    perror("connecting stream socket") ;
    exit(1) ;
  }
}
