#include "marshal.h"


/* uint => uint8_t */
void uint8_ms(char *buf, uint *offset, uint v) {
  buf[*offset] = v ;
  *offset = *offset + 1 ;
  return ;
}


/* uint => uint8_t */
uint uint8_um(char *buf, uint *offset) {
  unsigned char v ;

  v = buf[*offset] ;
  *offset = *offset + 1 ;
  return(v) ;
}


/* uint => uint16_t */
void uint16_ms(char *buf, uint *offset, uint v) {
  uint8_ms(buf, offset, v / 256) ;
  uint8_ms(buf, offset, v % 256) ;
  return ;
}


/* uint => uint16_t */
uint uint16_um(char *buf, uint *offset) {
  uint v ;

  v = uint8_um(buf, offset) ;
  v = v * 256 + uint8_um(buf, offset) ;
  return(v) ;
}


/* uint => uint32_t */
void uint32_ms(char *buf, uint *offset, uint v) {
  uint16_ms(buf, offset, v / 65536) ;
  uint16_ms(buf, offset, v % 65536) ;
  return ;
}


/* uint => uint32_t */
uint uint32_um(char *buf, uint *offset) {
  uint v ;

  v = uint16_um(buf, offset) ;
  v = v * 65536 + uint16_um(buf, offset) ;
  return(v) ;
}


void tv_ms(char *buf, size_t *offset, TV t) {
  uint32_ms(buf, offset, t.tv_sec) ;
  uint32_ms(buf, offset, t.tv_usec) ;
  return ;
}


TV tv_um(char *buf, size_t *offset) {
  TV t ;

  t.tv_sec = uint32_um(buf, offset) ;
  t.tv_usec = uint32_um(buf, offset) ;
  return(t) ;
}


/* The length of the string is restricted to one byte? */
void bytes_ms(char *buf, uint *offset, char *str, size_t len) {
  buf[*offset] = len ;
  bcopy(str, buf+*offset+1, len) ;
  *offset = *offset + len + 1 ;
  return ;
}
 

/* Pascal style: strlen followed by the str.
 */
void str_ms(char *buf, uint *offset, char *str) {
  bytes_ms(buf, offset, str, strlen(str)) ;
  /*  unsigned char len ;

  len = strlen(str) ;
  buf[*offset] = len ;
  strcpy(buf+*offset+1, str) ;
  *offset = *offset + len + 1 ;
  */
  return ;
}


char *str_um(char *buf, uint *offset) {
  char *str ;
  unsigned char len ;
  
  len = buf[*offset] ;
  str = Malloc(len+1) ;
  strncpy(str, buf+*offset+1, len) ;
  str[len] = '\0' ;
  *offset = *offset + len + 1 ;
  return(str) ;
}


void strarr_ms(char *buf, uint *offset, char **strarr, int cnt) {
  int i ;

  for (i = 0; i < cnt ; i++) {
    str_ms(buf, offset, strarr[i]) ;
  }
  return ;
}


char **strarr_um(char *buf, uint *offset, int cnt) {
  char **strarr ;
  int i ;

  strarr = Calloc(cnt, sizeof(char *)) ;
  for (i = 0; i < cnt; i++) {
    strarr[i] = str_um(buf, offset) ;
  }
  return(strarr) ;
}


/* Note: 
 *  (1) Only marshal IP and port.
 *  (2) Occupy 6 bytes.
 */
void addr_ms(char *buf, uint *offset, SAin addr) {
  unsigned long ip ;
  unsigned int port ;

  ip = htonl(addr.sin_addr.s_addr) ;
  port = htons(addr.sin_port) ;
  uint32_ms(buf, offset, ip) ;
  uint16_ms(buf, offset, port) ;
  return ;
}


SAin addr_um(char *buf, uint *offset) {
  SAin addr ;
  unsigned long ip ;
  unsigned int port ;

  bzero((char *) &addr, sizeof(addr)) ;
  addr.sin_family = AF_INET ;
  ip = uint32_um(buf, offset) ;
  port = uint16_um(buf, offset) ;
  addr.sin_addr.s_addr = ntohl(ip) ;
  addr.sin_port = ntohs(port) ;
  return(addr) ;
}


void addrarr_ms(char *buf, uint *offset, SAin *addrarr, int cnt) {
  int i ;

  for (i = 0; i < cnt; i++) {
    addr_ms(buf, offset, addrarr[i]) ;
  }
  return ;
}


SAin *addrarr_um(char *buf, uint *offset, int cnt) {
  SAin *addrarr ;
  int i ;

  addrarr = Calloc(cnt, sizeof(SAin)) ;
  for (i = 0; i < cnt; i++) {
    addrarr[i] = addr_um(buf, offset) ;
  }
  return(addrarr) ;
}



void int_array_ms(char *buf, size_t *offset, int *arr, size_t cnt) {
  int i ;

  for (i = 0; i < cnt; i++) {
    uint32_ms(buf, offset, arr[i]) ;
  }
  return ;
}


int *int_array_um(char *buf, size_t *offset, size_t cnt) {
  int *arr ;
  int i ;

  arr = Calloc(cnt, sizeof(int)) ;
  for (i = 0; i < cnt; i++) {
    arr[i] = uint32_um(buf, offset) ;
  }
  return(arr) ;
}


void seqno_array_ms(char *buf, size_t *offset, Seqno *arr, size_t cnt) {
  size_t i ;

  for (i = 0; i < cnt; i++) {
    seqno_ms(buf, offset, arr[i]) ;
  }
  return ;
}


Seqno *seqno_array_um(char *buf, size_t *offset, size_t cnt) {
  Seqno *arr ;
  size_t i ;

  arr = Calloc(cnt, sizeof(Seqno)) ;
  for (i = 0; i < cnt; i++) {
    arr[i] = seqno_um(buf, offset) ;
  }
  return(arr) ;
}


void bool_array_ms(char *buf, size_t *offset, bool *arr, size_t cnt) {
  int_array_ms(buf, offset, arr, cnt) ;
  return ;
}


bool *bool_array_um(char *buf, size_t *offset, size_t cnt) {
  return(int_array_um(buf, offset, cnt)) ;
}


void type_ms(char *buf, size_t *offset, Type type) {
  uint8_ms(buf, offset, type) ;
  return ;
}


Type type_um(char *buf, size_t *offset) {
  return(uint8_um(buf, offset)) ;
}


void bool_ms(char *buf, size_t *offset, bool b) {
  uint8_ms(buf, offset, b) ;
  return ;
}


bool bool_um(char *buf, size_t *offset) {
  return(uint8_um(buf, offset)) ;
}


void seqno_ms(char *buf, size_t *offset, Seqno seqno) {
  uint32_ms(buf, offset, seqno) ;
  return ;
}


Seqno seqno_um(char *buf, size_t *offset) {
  return(uint32_um(buf, offset)) ;
}


void rank_ms(char *buf, size_t *offset, Rank rank) {
  uint8_ms(buf, offset, rank) ;
}


void round_ms(char *buf, size_t *offset, Round round) {
  uint32_ms(buf, offset, round) ;
  return ;
}

