#include "all.h"

static struct state {
  bool first ;
  unsigned long total, nmsgs, lost_msg ;
  SAin origin ;
  size_t msg_len ;
  double hbt_rate ;
  TV end ;
  unsigned long limit ;
} s ;


static void final(void) {
  double loss_rate ;

  printf("Loss: nmsgs = %lu lost_msg = %lu ", s.total, s.lost_msg) ;
  if (s.total == 0) loss_rate = 0 ;
  else loss_rate = (100.0 * s.lost_msg) / s.total ;
  printf("loss_rate = %4.4f%%\n", loss_rate) ;
  return ;
}


static void recv_hbt(void) {
  double rate ;
  TV now ;

  rate = s.nmsgs / s.hbt_rate ;
  printf("#msgs = %lu recv_rate = %6.6f\n", s.total, rate) ;
  s.nmsgs = 0 ;
  now = Gettimeofday() ;
  if (time_expire(now, s.end)) final() ;
  return ;
}


static void recv_msg(char *msg, size_t msg_len, SAin origin) {
  static long seqno, prevseqno ;
  size_t gap_len ;

  if (s.first) {
    s.first = false ;
    s.nmsgs = s.total = 1 ;
    s.lost_msg = 0 ;
    prevseqno = atoi(msg) ;
    assert (prevseqno == 0) ;
    s.origin = origin ;
    s.msg_len = msg_len ;
    addr_print("origin", origin) ;
    printf("msg_len = %d\n", msg_len) ;

    s.hbt_rate = param_double("loss_hbt_rate") ;
    appl_recv_hbt = recv_hbt ;
    appl_hbt_rate = s.hbt_rate ;
    appl_start_hbt() ;
    return ;
  }

  /* Assume one sender is sending fixed size msgs */
  assert (addr_eq(origin, s.origin) && msg_len == s.msg_len) ;
  s.nmsgs++ ;
  s.total++ ;
  seqno = atoi(msg) ;
  if (seqno != prevseqno + 1) {
    assert (seqno > prevseqno) ;
    gap_len = seqno - prevseqno - 1 ;
    s.lost_msg += gap_len ;
    printf("Loss: msg_gap(%lu, %lu)[%u]\n", prevseqno, seqno, gap_len) ;
  }
  prevseqno = seqno ;
  if (s.total > s.limit) {
    appl_stop() ;
  }
  return ;
}


void main(int argc, char **argv) {
  double testtime ;

  appl_init(argc, argv) ;
  appl_recv_cast = recv_msg ;

  s.first = true ;
  testtime = param_double("testtime") ;
  s.end = time_set(testtime) ;
  s.limit = param_int("total") ;

  appl_final = final ;
  appl_main_loop() ;
}
